function yearDiff(birthday, today) {
    var diff = today.getFullYear() - birthday.getFullYear();
    var newBirthday = new Date(birthday);
    newBirthday.setFullYear(today.getFullYear());

    if (today < newBirthday) {
        diff--;
    }
    return diff;
}

function monthDiff(birthday, today) {
    var months;
    months = (today.getFullYear() - birthday.getFullYear()) * 12;
    months -= birthday.getMonth() + 1;
    months += today.getMonth();
    // edit: increment months if today comes later in its month than birthday in its month
    if (today.getDate() >= birthday.getDate())
        months++
    // end edit
    return months <= 0 ? 0 : months;
}

function dayDiff(birthday, today) {
    var oneDay = 24*60*60*1000; // hours*minutes*seconds*milliseconds
    var diffDays = Math.round(Math.abs((birthday.getTime() - today.getTime())/(oneDay)));
    return diffDays;
}

var start = new Date(1990, 7, 4);
var end = new Date(2015, 7, 5);

function ageCalculator(start, end) {

    var years = yearDiff(start, end),
        months,
        days,
        retVal = {
            years: 0,
            months: 0,
            days: 0,
        };

    if (end.getMonth() > start.getMonth()) {
        start.setFullYear(end.getFullYear());
        months = monthDiff(start, end);
        if (end.getDate() > start.getDate()) {
            start.setMonth(end.getMonth());
            days = dayDiff(start, end);
        } else if (end.getDate() < start.getDate()) {
            start.setMonth(end.getMonth() - 1);
            days = dayDiff(start, end);
        } else {
            days = 0;
        }
    } else if (end.getMonth() < start.getMonth()) {
        start.setFullYear(end.getFullYear() - 1);
        months = monthDiff(start, end);
        if (end.getDate() > start.getDate()) {
            start.setMonth(end.getMonth());
            start.setFullYear(end.getFullYear());
            days = dayDiff(start, end);
        } else if (end.getDate() < start.getDate()) {
            start.setMonth(end.getMonth() - 1);
            start.setFullYear(end.getFullYear());
            days = dayDiff(start, end);
        } else {
            days = 0;
        }
    } else {
        if (end.getDate() > start.getDate()) {
            months = 0;
            start.setFullYear(end.getFullYear());
            days = dayDiff(start, end);
        } else if (end.getDate() < start.getDate()) {
            months = 11;
            start.setMonth(end.getMonth() - 1);
            start.setFullYear(end.getFullYear());
            days = dayDiff(start, end);
        } else {
            months = 0;
            days = 0;
        }
    }

    retVal.years = years;
    retVal.months = months;
    retVal.days = days;

    return retVal;
}