var month = [ 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, undefined ];

function convertJapaneseYear( $year ){
    var $tmp;
    if( $year > 2019 ){
        $tmp = $year - 2018;
        $tmp = '令和' + $tmp + '年';
        return $tmp;
    }else if( $year  == 2019 ){
        $tmp = '平成31年,令和1年';
        return $tmp;
    }else if( $year  > 1989 ){
        $tmp = $year - 1988;
        $tmp = '平成' + $tmp + '年';
        return $tmp;
    }else if( $year  == 1989 ){
        $tmp = '昭和64年,平成1年';
        return $tmp;
    }else if( $year  > 1926 ){
        $tmp = $year  - 1925;
        $tmp = '昭和' + $tmp + '年';
        return $tmp;
    }else if( $year  == 1926 ){
        $tmp = '大正15年,昭和1年';
        return $tmp;
    }else if( $year  > 1911 ){
        $tmp = $year  - 1911;
        $tmp = '大正' + $tmp + '年';
        return $tmp;
    }
    return "";
}

function setYear( $yearObj , $startYear , $endYear , $undefine ){

    $yearObj.empty();
    $yearObj.append("<option value=''>年</option>");
    for( var i = $endYear ; i >= $startYear ; i-- ){
        var year = i +'年' + '(' + convertJapaneseYear(i) + ')';
       $yearObj.append("<option value='" + i + "'>" + year + "</option>");
    }
    if( $undefine ){
        $yearObj.append("<option value=unknown>不明</option>");
    }
}

function setMonth( $monthObj ,$undefine ) {
   $monthObj.empty();
   $monthObj.append("<option value=''>月</option>");
   for( var i = 1 ; i <= 12 ; i++ ){
       var month = i +'月';
     if ( month.length == 2 ) {
       $monthObj.append("<option value='" + '0' + i + "'>" + month + "</option>");
     }else{
       $monthObj.append("<option value='" + i + "'>" + month + "</option>");
     }
   }
    if( $undefine ){
        $monthObj.append("<option value=unknown>不明</option>");
    }
}

function setDayAction( $monthId , $dayId , $undefine )
{
    $monthId.on("change",function() {

        var key = $(this).val();
        if( key == 'null' ){
            key = 1;
        }
        var arr = month[key-1];

        $dayId.empty();
        $dayId.append("<option value=''>日</option>");
        for( var i = 1 ; i <= arr  ; i++ ){
            $dayId.append("<option value='" + i + "'>" + i +  "日</option>");
        }

        if( $undefine ){
            $dayId.append("<option value=unknown>不明</option>");
        }
    });

    $monthId.trigger("change");
}

function setHour( $hourObj ,$undefine ) {
   $hourObj.empty();
   $hourObj.append("<option value=''>時</option>");
   for( var i = 0 ; i <= 23 ; i++ ){
       var hour = i +'時';
     if ( hour.length == 2 ) {
       $hourObj.append("<option value='" + '0' + i + "'>" + hour + "</option>");
     }else{
       $hourObj.append("<option value='" + i + "'>" + hour + "</option>");
     }
   }
    if( $undefine ){
        $hourObj.append("<option value=unknown>不明</option>");
    }
}

function setMinute( $minuteObj ,$undefine ) {
   $minuteObj.empty();
   $minuteObj.append("<option value=''>分</option>");
   for( var i = 0 ; i <= 59 ; i++ ){
       var minute = i +'分';
     if ( minute.length == 2 ) {
       $minuteObj.append("<option value='" + '0' + i + "'>" + minute + "</option>");
     }else{
       $minuteObj.append("<option value='" + i + "'>" + minute + "</option>");
     }
   }
    if( $undefine ){
        $minuteObj.append("<option value=unknown>不明</option>");
    }
}

// 4/16修正 No1,4
function setPrefectures( $prefectureObj) {
   $prefectureObj.empty();
   $prefectureObj.append("<option value=''>都道府県</option>");
   $prefectureObj.append("<option value='1'>北海道</option>");
   $prefectureObj.append("<option value='2'>青森県</option>");
   $prefectureObj.append("<option value='3'>岩手県</option>");
   $prefectureObj.append("<option value='4'>宮城県</option>");
   $prefectureObj.append("<option value='5'>秋田県</option>");
   $prefectureObj.append("<option value='6'>山形県</option>");
   $prefectureObj.append("<option value='7'>福島県</option>");
   $prefectureObj.append("<option value='8'>茨城県</option>");
   $prefectureObj.append("<option value='9'>栃木県</option>");
   $prefectureObj.append("<option value='10'>群馬県</option>");
   $prefectureObj.append("<option value='11'>埼玉県</option>");
   $prefectureObj.append("<option value='12'>千葉県</option>");
   $prefectureObj.append("<option value='13'>東京都</option>");
   $prefectureObj.append("<option value='14'>神奈川県</option>");
   $prefectureObj.append("<option value='15'>新潟県</option>");
   $prefectureObj.append("<option value='16'>富山県</option>");
   $prefectureObj.append("<option value='17'>石川県</option>");
   $prefectureObj.append("<option value='18'>福井県</option>");
   $prefectureObj.append("<option value='19'>山梨県</option>");
   $prefectureObj.append("<option value='20'>長野県</option>");
   $prefectureObj.append("<option value='21'>岐阜県</option>");
   $prefectureObj.append("<option value='22'>静岡県</option>");
   $prefectureObj.append("<option value='23'>愛知県</option>");
   $prefectureObj.append("<option value='24'>三重県</option>");
   $prefectureObj.append("<option value='25'>滋賀県</option>");
   $prefectureObj.append("<option value='26'>京都府</option>");
   $prefectureObj.append("<option value='27'>大阪府</option>");
   $prefectureObj.append("<option value='28'>兵庫県</option>");
   $prefectureObj.append("<option value='29'>奈良県</option>");
   $prefectureObj.append("<option value='30'>和歌山県</option>");
   $prefectureObj.append("<option value='31'>鳥取県</option>");
   $prefectureObj.append("<option value='32'>島根県</option>");
   $prefectureObj.append("<option value='33'>岡山県</option>");
   $prefectureObj.append("<option value='34'>広島県</option>");
   $prefectureObj.append("<option value='35'>山口県</option>");
   $prefectureObj.append("<option value='36'>徳島県</option>");
   $prefectureObj.append("<option value='37'>香川県</option>");
   $prefectureObj.append("<option value='38'>愛媛県</option>");
   $prefectureObj.append("<option value='39'>高知県</option>");
   $prefectureObj.append("<option value='40'>福岡県</option>");
   $prefectureObj.append("<option value='41'>佐賀県</option>");
   $prefectureObj.append("<option value='42'>長崎県</option>");
   $prefectureObj.append("<option value='43'>熊本県</option>");
   $prefectureObj.append("<option value='44'>大分県</option>");
   $prefectureObj.append("<option value='45'>宮崎県</option>");
   $prefectureObj.append("<option value='46'>鹿児島県</option>");
   $prefectureObj.append("<option value='47'>沖縄県</option>");
}

