// furigana.js
(function($){
	$.fn.furigana = function(target){
			$.furigana(this, target);
	};
	$.furigana = function(container,target){
		var furigana = "";
		var current = $(container).val();
		$(container).keyup(function(){
			newChar = $(this).val();
			if(newChar==""){
				furigana = "";
				$(target).val("");
				current = $(container).val();
			}
			else{
				for(var i=current.length; i>=0; i--) {
					if (newChar.substr(0,i) == current.substr(0,i)) {
						newChar = newChar.substr(i);break;
					}
				}
				if(!newChar.match(/ア-ン/g)){
					newChar = newChar.replace(/[^ 　ぁあ-んァー]/g, "");
					if ($(target).val().match(newChar)){ return; }
					furigana += $.furigana.tokatakana(newChar);
					$(target).val(furigana);
					current = $(container).val();
				}
			}
		});
		$(target).keyup(function(){
			furigana = $(target).val();
		});
	};
	$.furigana.tokatakana = function(text){
		var i, charCode, m, charArray = [];
		for(i=text.length-1;0<=i;i--){
			charCode = text.charCodeAt(i);
			if(0x3041 <= charCode && charCode <= 0x3096){
				charArray[i] = charCode + 0x0060 ;
			}
			else{
				charArray[i] = charCode;
			}
		}
		return String.fromCharCode.apply(null, charArray);
	};
})(jQuery);