"use strict";

$(document).ready(function() {

  var count = 1;
  var allNotCheck = true;
  var blueShipLab = function() {};

  blueShipLab.prototype.init = function() {
    this.navLinks = $('.nav-tabs li a');
    this.validateForm = $('.form');
//    this.btnPrintf = $('.btn-printf');
    this.btnSavePrintf = $('.btn-savePrintf');
    this.btnSaveData = $('.saveData');
    this.btnLoadData = $('.loadData');
    this.btnSaveReporterData = $('.saveReporterData');
    this.btnLoadReporterData = $('.loadReporterData');
    this.radio = $('input[type="radio"],input[type="checkbox"]');
    this.firstTable = $('.first-table');
    this.btnChangeFont = $('.change-font-size');
    this.btnToggleHelpOn = $('.btnToggleHelpOn');
    this.btnToggleHelpOff = $('.btnToggleHelpOff');
    this.selectedPosition = $('.check-position');
    this.selectedAttention = $('.check-attention');
    this.checkedLotUnknown = $('.check-lotUnknown');
    this.checkedSymptom = $('.check-cheked-otherSymptom');
    this.notHeavyClearError = $('.check-notHeavy');
    this.checkedHospitalized = $('.check-hospitalized');
    this.selectedOutcome = $('.check-outcome');
    this.selectedOtherSick = $('.check-othersick');
    this.checkBirthdayFields = $('.check-birthday');
    this.checkDateOccursFields = $('.check-DateOccurs');
    this.onYearClearVaccination = $('.clear-vac-date-year');
    this.onMonthClearVaccination = $('.clear-vac-date-month');
    this.onDayClearVaccination = $('.clear-vac-date-day');
    this.onHourClearVaccination = $('.clear-vac-date-hour');
    this.checkSymptomNumOthers =$('.check_symptom_others');
    this.html = $('html');
    this.document = $(document);
    this.window = $(window);

    this.bindEvents();
  };

  blueShipLab.prototype.bindEvents = function() {
    this.bindNavLinks();
    this.bindValidate();
    this.bindAgeValidate();
    this.bindVaccinessNameChack();
    this.bindVaccinessLastNameChack();
    this.symptomCheckOthers();
    this.clearOtherSymptom();
//    this.bindPrintf();
    this.bindSavePrintf();
    this.saveData();
    this.loadData();
    this.saveReporterData();
    this.loadReporterData();
    this.bindRadioChange();
    this.onPosition();
    this.onAttention();
    this.lotNoClearError();
    this.symptomClearError();
    this.onNotHeavyClearError();
    this.onHospitalized();
    this.onOutcome();
    this.onOtherSick();
    this.onChangeBirthDay();
    this.onChangeDateOccurs();
    this.onChangeVaccinationYear();
    this.onChangeVaccinationMonth();
    this.onChangeVaccinationDay();
    this.onChangeVaccinationHour();
    this.bindCloneTable();
    this.removeClonedTable();
    this.removeCloneTime();
    this.bindJapaneseYear();
    this.bindAppendSymptom();
    this.bindAppendSymptomByChangeType();
    this.bindChangeDecimal();
    this.bindFuriganaShim();
    this.bindToggleNav();
    this.bindChangeFont();
    this.toggleHelp();
  };

  blueShipLab.prototype.bindNavLinks = function() {
    var self = this;
    self.navLinks.click(function(e) {
      e.preventDefault();
      $(this).tab('show');
    });
  };

  blueShipLab.prototype.bindValidate = function() {

    jQuery.validator.addMethod("checkNowMonth",function(value,element) {
      var time = new Date();
      var eleData = element.id;
      var yearAdd = eleData.replace("month","year");
      var year = $('#'+yearAdd).val();
      var month = value;
      if (time.getFullYear() > year || year == "" || year == "unknown") {
        return true;
      }else if (time.getFullYear() == year) {
        var compMonth = time.getMonth() + 1;
        if(compMonth >= month || month == "" || month == "unknown") {
          return true;
        }else{
          return false;
        }
      }else{
        return false;
      }
    },"本日より未来は入力できません");

    jQuery.validator.addMethod("checkNowDate",function(value,element) {
      var time = new Date();
      var eleData = element.id;
      var yearAdd = eleData.replace("days","year");
      var monthAdd = eleData.replace("days","month");
      var year = $('#'+yearAdd).val();
      var month = $('#'+monthAdd).val();
      var dates = value;

      if (time.getFullYear() > year || year == "" || year == "unknown") {
        return true;
      }else if (time.getFullYear() == year) {
        var compMonth = time.getMonth() + 1;
        if(compMonth > month || month == "" || month == "unknown") {
          return true;
        }else if(compMonth == month) {
          if(time.getDate() >= dates || dates == "" || dates == "unknown") {
            return true;
          }else{
            return false;
          }
        }else{
          return false;
        }
      }else{
        return false;
      }
    },"本日より未来は入力できません");

    
    jQuery.validator.addMethod("checkFromBirth",function(value,element) {
      var eleData = element.id;
      var idAdd = eleData.replace("year","");
      idAdd = idAdd.replace("month","");
      idAdd = idAdd.replace("days","");
      idAdd = idAdd.replace("-","");
      if (idAdd.indexOf("vaccine_") != -1) {
        var number_vac = idAdd.replace("vaccine_","");
        var errEle = document.getElementById("vaccine_err_"+number_vac);
      }else{
        var errEle = document.getElementById(idAdd+"_err");
      }
      var year = $('#year-'+idAdd).val();
      var month = $('#month-'+idAdd).val();
      var dates = $('#days-'+idAdd).val();
      if (dates.length == 1){
        dates = "0" + dates;
      }
      var birthYear = $('#year-birthday').val();
      var birthMonth = $('#month-birthday').val();
      var birthDate = $('#days-birthday').val();
      if (birthDate.length == 1){
        birthDate = "0" + birthDate;
      }
      if (birthYear == "" || birthYear == "unknown" || year == "" || year=="unknown" || birthYear < year) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else if ( birthYear > year ) {
        errEle.innerHTML = "生年月日より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      if (birthMonth == "" || birthMonth == "unknown" || month == "" || month =="unknown" || birthMonth < month) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else if ( birthMonth > month ){
        errEle.innerHTML = "生年月日より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      if (birthDate == "" || birthDate == "unknown" || birthDate == null || dates == "" || dates == "unknown" || dates == null || birthDate <= dates) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else{
        errEle.innerHTML = "生年月日より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
    },"");

    jQuery.validator.addMethod("checkFromHospi",function(value,element) {
      var eleData = element.id;
      var idAdd = eleData.replace("year","");
      idAdd = idAdd.replace("month","");
      idAdd = idAdd.replace("days","");
      idAdd = idAdd.replace("-","");
      if (idAdd.indexOf("vaccine_") != -1) {
        var number_vac = idAdd.replace("vaccine_","");
        var errEle = document.getElementById("vaccine_err_"+number_vac);
      }else{
        var errEle = document.getElementById(idAdd+"_hospi_err");
      }
      var year = $('#year-'+idAdd).val();
      var month = $('#month-'+idAdd).val();
      var dates = $('#days-'+idAdd).val();
      if (dates.length == 1){
        dates = "0" + dates;
      }
      var hospiYear = $('#year-hospitalized').val();
      var hospiMonth = $('#month-hospitalized').val();
      var hospiDate = $('#days-hospitalized').val();
      if (hospiDate.length == 1){
        hospiDate = "0" + hospiDate;
      }
      if (hospiYear == "" || hospiYear == "unknown" || year == "" || year=="unknown" || hospiYear < year) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else if ( hospiYear > year ) {
        errEle.innerHTML = "入院日より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      if (hospiMonth == "" || hospiMonth == "unknown" || month == "" || month =="unknown" || hospiMonth < month) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else if ( hospiMonth > month ){
        errEle.innerHTML = "入院日より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      if (hospiDate == "" || hospiDate == "unknown" || hospiDate == null || dates == "" || dates == "unknown" || dates == null || hospiDate <= dates) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else{
        errEle.innerHTML = "入院日より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
    },"");

    jQuery.validator.addMethod("checkFromOccur",function(value,element) {
      var eleData = element.id;
      var idAdd = eleData.replace("year","");
      idAdd = idAdd.replace("month","");
      idAdd = idAdd.replace("days","");
      idAdd = idAdd.replace("-","");
      if (idAdd.indexOf("vaccine_") != -1) {
        var number_vac = idAdd.replace("vaccine_","");
        var errEle = document.getElementById("vaccine_err_"+number_vac);
      }else{
        var errEle = document.getElementById(idAdd+"_occur_err");
      }
      if(!errEle) return true;
      var year = $('#year-'+idAdd).val();
      var month = $('#month-'+idAdd).val();
      var dates = $('#days-'+idAdd).val();
      if (dates.length == 1){
        dates = "0" + dates;
      }
      var occurYear = $('#year-symptom').val();
      var occurMonth = $('#month-symptom').val();
      var occurDate = $('#days-symptom').val();
      if (occurDate.length == 1){
        occurDate = "0" + occurDate;
      }
      if (occurYear == "" || occurYear == "unknown" || year == "" || year=="unknown" || occurYear < year) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else if ( occurYear > year ) {
        // 4/16修正 No12
        errEle.innerHTML = "発生日時より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      if (occurMonth == "" || occurMonth == "unknown" || month == "" || month =="unknown" || occurMonth < month) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else if ( occurMonth > month ){
        // 4/16修正 No12
        errEle.innerHTML = "発生日時より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      if (occurDate == "" || occurDate == "unknown" || occurDate == null || dates == "" || dates == "unknown" || dates == null || occurDate <= dates) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else{
        // 4/16修正 No12
        errEle.innerHTML = "発生日時より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
    },"");

    jQuery.validator.addMethod("checkToOccur",function(value,element) {
      var eleData = element.id;
      var idAdd = eleData.replace("year","");
      idAdd = idAdd.replace("month","");
      idAdd = idAdd.replace("days","");
      idAdd = idAdd.replace("-","");
      if (idAdd.indexOf("vaccine_") != -1) {
        var number_vac = idAdd.replace("vaccine_","");
        var errEle = document.getElementById("vaccine_err_"+number_vac);
      }else{
        var errEle = document.getElementById(idAdd+"_occur_err");
      }
      var year = $('#year-'+idAdd).val();
      var month = $('#month-'+idAdd).val();
      var dates = $('#days-'+idAdd).val();
      if (dates.length == 1){
        dates = "0" + dates;
      }
      var occurYear = $('#year-symptom').val();
      var occurMonth = $('#month-symptom').val();
      var occurDate = $('#days-symptom').val();
      if (occurDate.length == 1){
        occurDate = "0" + occurDate;
      }
      if (occurYear == "" || occurYear == "unknown" || year == "" || year=="unknown" || occurYear > year) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else if ( occurYear < year ) {
        errEle.innerHTML = "発生日時より未来の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      if (occurMonth == "" || occurMonth == "unknown" || month == "" || month =="unknown" || occurMonth > month) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else if ( occurMonth < month ){
        errEle.innerHTML = "発生日時より未来の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      if (occurDate == "" || occurDate == "unknown" || occurDate == null || dates == "" || dates == "unknown" || dates == null || occurDate >= dates) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else{
        errEle.innerHTML = "発生日時より未来の日付になっています ";
        errEle.style.display = "";
        return false;
      }
    },"");

    
    jQuery.validator.addMethod("checkOccurTerm",function(value,element) {
      var self = this;
      var Default = true;

      $('.check-DateOccurs').each(function() {
        
        
        if ( $(this).val() == null ) {
          var checkBirthDay = $(this).id;
        }else{
          var checkBirthDay = $(this).val().length;
        }
        if (checkBirthDay == 0) {
          Default = false;
        }
      });

      if (!Default) {
        //初期化を行う ここで発生日時の初期化を行う
        // 4/16修正 No9
        var results = '';
        var days = '';
        var hours = '';
        $('.date_occurs_days').val(days);
        $('.date_occurs_times').val(hours);
        document.getElementById("occurs_term_lbl").innerText = results;
        return true;
      }

      var obj = document.getElementById("term_error");
      obj.innerText = "";
      obj.style.display = "none";
      
      var latesttime = new Date(1916, 0 , 1 );
      var latesttimeEx = new Date(1916, 0 , 1 );
      var h_checkUnknown = false;
      var m_checkUnknown = false;
      var h_unknown = false;
      var m_unknown = false;
      var reHour = 0;
      var reMinute = 0;
      for( var i = 1 ; i <= count ; i++ ){
         var year = $('#year-vaccine_'+i).val();
         var month = $('#month-vaccine_'+i).val();
         var day = $('#days-vaccine_'+i).val();
         var hour = $('#hour-vaccine_'+i).val();
         var minute = $('#minute-vaccine_'+i).val();
         h_checkUnknown = false;
         m_checkUnknown = false;
         if (hour == "unknown") {
           hour = 0
           h_checkUnknown = true;
         }
         if (minute == "unknown") {
           minute = 0
           m_checkUnknown = true;
         }
         var time = new Date(year, month - 1, day,hour,minute);
         var timeEx= new Date(year, month - 1, day,0,0);
         if( i==1 ) {
             latesttime = time;
             latesttimeEx = timeEx;
             h_unknown = h_checkUnknown;
             m_unknown = m_checkUnknown;
             reHour = hour;
             reMinute = minute;
         }else if (isNaN(latesttime)) {
             latesttime = time;
             latesttimeEx = timeEx;
             h_unknown = h_checkUnknown;
             m_unknown = m_checkUnknown;
             reHour = hour;
             reMinute = minute;
         }else if( time.getTime() > latesttime.getTime() ){
             latesttime = time;
             latesttimeEx = timeEx;
             h_unknown = h_checkUnknown;
             m_unknown = m_checkUnknown;
             reHour = hour;
             reMinute = minute;
         }
      }
      
      var DateTimeStart = latesttime;
      
      var DateTimeStartExTime = latesttimeEx;
         if (hour == "unknown") {
           hour = 0;
           p_checkUnknown = true;
         }
         if (minute == "unknown") {
           minute = 0;
         }
      var timeUnknownHour = h_unknown
      var timeUnknownMinute = m_unknown;
      var startHour = reHour;
      var startMinute = reMinute;
      
      var endYear  = $('.wrap-date-occurs .Year-follow-JapaneseCalendar').val();
      var endMonth = $('.wrap-date-occurs .Month-follow-JapaneseCalendar').val();
      var endDate  = $('.wrap-date-occurs .Date-follow-JapaneseCalendar').val();
      var endHour  = $('.wrap-date-occurs .Hour-follow-JapaneseCalendar').val();
      var endMinute = $('.wrap-date-occurs .Minute-follow-JapaneseCalendar').val();
      if (timeUnknownMinute) {
        endMinute = 0;
      }
      if (endMinute == "unknown") {
        endMinute = startMinute;
        timeUnknownMinute = true;
      }
      if (timeUnknownHour) {
        endHour = 0;
        endMinute = startMinute;
      }
      if (endHour == "unknown") {
        endHour = startHour;
        endMinute = startMinute;
        timeUnknownHour = true;
      }
      var DateTimeEnd = new Date(endYear, endMonth-1 , endDate, endHour, endMinute);
      var DateTimeEndExTime = new Date(endYear, endMonth-1 , endDate, 0, 0);

      var Milisecond = DateTimeEnd - DateTimeStart;
      var MilisecondExTime = DateTimeEndExTime - DateTimeStartExTime;
      var Second = Math.floor(Milisecond / 1000);

      var Days = Math.floor(Second / 86400);

      var balances = Second % 86400;
      var Hours = Math.floor(balances / 3600);

      balances = balances % 3600;
      var Minutes = Math.floor(balances / 60);
      
      var rtnFlg = false;
      if ( isNaN( Milisecond ) ) {
        var results ='計算不能';
        var days = '不明';
        var hours = '';
        rtnFlg = true;
      }else if ( MilisecondExTime < 0 ){
        var obj = document.getElementById("term_error");
        obj.innerText = "発生日時が接種日時より過去の日付になっています";
        obj.style.display = "";
        var results ='期間が負の日数です';
        var days = '不明';
        var hours = '';
        rtnFlg = false;
      }else if (timeUnknownHour) {
        var results = Days + '日 ';
        var days = Days + '日 ';
        var hours = '不明';
        rtnFlg = true;
      }else if ( Days < 0 || Hours < 0 ){
        var obj = document.getElementById("term_error");
        obj.innerText = "発生日時が接種日時より過去の日付になっています";
        obj.style.display = "";
        var results ='期間が負の日数です';
        var days = '不明';
        var hours = '';
        rtnFlg = false;
      }else if (timeUnknownMinute) {
        var results = Days + '日 ' + Hours + '時間 ';
        var days = Days + '日 ';
        var hours = Hours + '時間 ';
        rtnFlg = true;
      }else if ( Milisecond < 0 ){
        var obj = document.getElementById("term_error");
        obj.innerText = "発生日時が接種日時より過去の日付になっています";
        obj.style.display = "";
        var results ='期間が負の日数です';
        var days = '不明';
        var hours = '';
        rtnFlg = false;
      }else{
        var results = Days + '日 ' + Hours + '時間 ' + Minutes + '分';
        var days = Days + '日 ';
        var hours = Hours + '時間 ' + Minutes + '分';
        rtnFlg = true;
      }
      $('.date_occurs_days').val(days);
      $('.date_occurs_times').val(hours);
      document.getElementById("occurs_term_lbl").innerText = results;
      return rtnFlg;
    },"");
    
    jQuery.validator.addMethod("checkFromVaccine",function(value,element) {
      var eleData = element.id;
      var idAdd = eleData.replace("year","");
      idAdd = idAdd.replace("month","");
      idAdd = idAdd.replace("days","");
      idAdd = idAdd.replace("-","");
      var errEle = document.getElementById(idAdd+"_vaccine_err");
//      if (idAdd.indexOf("vaccine_") != -1) {
//        var number_vac = idAdd.replace("vaccine_","");
//        var errEle = document.getElementById("vaccine_err_"+number_vac);
//      }else{
//        var errEle = document.getElementById(idAdd+"_occur_err");
//      }
      var year = $('#year-'+idAdd).val();
      var month = $('#month-'+idAdd).val();
      var dates = $('#days-'+idAdd).val();
      if (dates.length == 1){
        dates = "0" + dates;
      }
      var checkFlg = true;
      
      for (var i=1;i<11;i++) {
        var vaccineYear = $('#year-vaccine_'+i).val();
//        if (vaccineYear == null) {
//          return true;
//        }
        var vaccineMonth = $('#month-vaccine_'+i).val();
        var vaccineDate = $('#days-vaccine_'+i).val();
        if (vaccineDate != null) {
          if (vaccineDate.length == 1){
            vaccineDate = "0" + vaccineDate;
          }
        }
        if (vaccineYear == "" || vaccineYear == "unknown" || year == "" || year=="unknown" || vaccineYear < year) {
        }else if ( vaccineYear > year ) {
          checkFlg = false;
        }else if (vaccineMonth == "" || vaccineMonth == "unknown" || month == "" || month =="unknown" || vaccineMonth < month) {
        }else if ( vaccineMonth > month ){
          checkFlg = false;
        }else if (vaccineDate != "" && vaccineDate != "unknown" && vaccineDate != null && dates != "" && dates != "unknown" && dates != null ) {
          if (vaccineDate > dates) {
            checkFlg = false;
          }
        }
      }
      
      if (checkFlg) {
        errEle.innerHTML = "";
        errEle.style.display = "none";
        return true;
      }else{
        // 4/16修正 No12
        errEle.innerHTML = "接種日時より過去の日付になっています ";
        errEle.style.display = "";
        return false;
      }
      
    },"");
    jQuery.validator.addMethod("checkKana",function(value,element) {
        // 4/16修正 No2,3
      return this.optional(element) || /^([ァ-ヶーｱ-ﾝﾞﾟｰ]+)$/.test(value);
    },"カタカナで入力してください");

    //##########  感染研様編集希望項目ここから  ########
    // ロット番号入力チェックをここで行っています。編集する場合は
    // return this.optional(element) || /^[0-9A-Za-z-]+$/.test(value);の部分の[0-9A-Za-z-]中身を編集します
    // 例1：/(スラッシュ)を追加したい場合
    // return this.optional(element) || /^[0-9A-Za-z-/]+$/.test(value);
    //
    // 例2：全角英文字と全角ハイフンを追加したい場合
    // return this.optional(element) || /^[0-9A-Za-z-Ａ-ｚ－]+$/.test(value);
        
    jQuery.validator.addMethod("checkNoTwoByte",function(value,element) {
      return this.optional(element) || /^[0-9A-Za-z-]+$/.test(value);
    },"半角英数記号で入力してください(記号は「-：ハイフン」のみ可)");
  
    //##########  感染研様編集希望項目ここまで  ########
    jQuery.validator.addMethod("checkDeadAndDeath",function(value,element) {
      var heavy = document.getElementById("heavy");
      var dead = document.getElementById("dead");
      var resultDead = document.getElementById("resultDead");
      if (heavy == null && dead == null && resultDead == null) {
        return true;
      }else if (heavy.checked && dead.checked ){
        if ( resultDead.checked ) {
          return true;
        }else{
          return false;
        }
      }
      return true;
    },"症状の程度で「死亡」を選択した場合は、転帰も「死亡」を選択してください");
    jQuery.validator.addMethod("checkSameVaccineSameDate",function(value,element) {
      var eleData = element.id;
      var idAdd = eleData.replace("year","");
      idAdd = idAdd.replace("month","");
      idAdd = idAdd.replace("days","");
      idAdd = idAdd.replace("-","");
      idAdd = idAdd.replace("_","");
      idAdd = idAdd.replace("type","");
      idAdd = idAdd.replace("vaccine","");
//      if (idAdd.indexOf("vaccine_") != -1) {
//        var number_vac = idAdd.replace("vaccine_","");
//        var errEle = document.getElementById("vaccine_err_"+number_vac);
//      }else{
//        var errEle = document.getElementById(idAdd+"_occur_err");
//      }
      var errEle = document.getElementById("vaccine_same_err_"+idAdd);
//      if (errEle != null) {
//        errEle.innerHTML = "";
//        errEle.style.display = "none";
//      }
      var vac = $('#vaccine-type_'+idAdd).val();
      var year = $('#year-vaccine_'+idAdd).val();
      var month = $('#month-vaccine_'+idAdd).val();
      var dates = $('#days-vaccine_'+idAdd).val();
      var vacNm = $('#vaccine-type_'+idAdd).val();
      if (dates != null && dates != "") {
        if (dates.length == 1){
          dates = "0" + dates;
        }
      }
      if ( vacNm != "Blank" && year != "" && month != "" && dates != "" ) {
      for (var i=1;i<11;i++) {
        if ( i != idAdd ) {
          var vaccineYear = $('#year-vaccine_'+i).val();
          if ( vaccineYear != null ) {
            var vaccineMonth = $('#month-vaccine_'+i).val();
            var vaccineDate = $('#days-vaccine_'+i).val();
            if (vaccineDate.length == 1){
              vaccineDate = "0" + vaccineDate;
            }
            var vaccineName = $('#vaccine-type_'+i).val();
            if ( vaccineName !="Blank") {
              if (vacNm == vaccineName && vaccineYear == year && vaccineMonth == month && vaccineDate == dates) {
//                errEle.innerHTML = "同じワクチンで同じ接種日時の場合は、入力できません ";
//                errEle.style.display = "";
                return false;
              }
            }
          }
        }
      }
      }
      return true;
      /*
      //変更のたびに全件チェック
      var checkFlg = true;
      //エラーの初期化
      for (var i=1;i<11;i++) {
        var errEle = document.getElementById("vaccine_same_err_"+i);
        if (errEle != null) {
          errEle.innerHTML = "";
          errEle.style.display = "none";
        }
      }
      //全件チェック
      for (var i=1;i<11;i++) {
        var errEle = document.getElementById("vaccine_same_err_"+i);
        if (errEle != null) {
          var vac = $('#vaccine-type_'+i).val();
          var year = $('#year-vaccine_'+i).val();
          var month = $('#month-vaccine_'+i).val();
          var dates = $('#days-vaccine_'+i).val();
          var vacNm = $('#vaccine-type_'+i).val();
          if (dates.length == 1){
            dates = "0" + dates;
          }
          if ( vacNm != "Blank" && year != "" && month != "" && dates != "" ) {
            for (var j=i;j<11;j++) {
              if ( i != j ) {
                var vaccineYear = $('#year-vaccine_'+j).val();
                if ( vaccineYear != null ) {
                  var vaccineMonth = $('#month-vaccine_'+j).val();
                  var vaccineDate = $('#days-vaccine_'+j).val();
                  if (vaccineDate.length == 1){
                    vaccineDate = "0" + dates;
                  }
                  var vaccineName = $('#vaccine-type_'+j).val();
                  if ( vaccineName !="Blank") {
                    if (vacNm == vaccineName && vaccineYear == year && vaccineMonth == month && vaccineDate == dates) {
                      errEle.innerHTML = "同じワクチンで同じ接種日時の場合は、入力できません ";
                      errEle.style.display = "";
                      var errorEle = document.getElementById("vaccine_same_err_"+j);
                      errorEle.innerHTML = "同じワクチンで同じ接種日時の場合は、入力できません ";
                      errorEle.style.display = "";
                      checkFlg = false;
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (checkFlg) {
        return true;
      }else{
        return false;
      }
      */
        // 4/16修正 No12
    },"同じワクチンで同じ接種日時の場合は、入力できません ");

    jQuery.validator.addMethod("checkOnehandredDays",function(value,element) {
    //投与日チェック
      var checkFlg = true;
      var year = document.getElementById("year-tts5-04").value;
      var month = document.getElementById("month-tts5-04").value;
      var days = document.getElementById("days-tts5-04").value;
      var errEle = document.getElementById("tts5-04_err");

      if (year != "unknown" && month != "unknown" && days != "unknown") {
        //発症日
        var onsetdays = document.getElementById("tts1-38").value
        if (onsetdays != "年月日不明") {
          if (onsetdays.indexOf("日") != -1) {
            //処理開始
            var check = onsetdays.indexOf("月");
            var check2 =onsetdays.indexOf("日");
 
            var date1 = new Date(onsetdays.substring(0,4),onsetdays.substring(5,onsetdays.indexOf("月")),onsetdays.substring(onsetdays.indexOf("月")+1,onsetdays.indexOf("日")));
            var date2 = new Date(year,month,days);
            var termDay =(date1 - date2) /86400000;
            if (termDay > 100) {
              errEle.innerHTML = "発症日までの100日間より過去の日付になっています";
              errEle.style.display = "";
              checkFlg = false;
            }else{
              errEle.innerHTML = "";
              errEle.style.display = "none";
              checkFlg = true;
            }
          }
        }
      }
      if (checkFlg) {
        return true;
      }else{
        return false;
      }
    },"");
    var self = this;
    var errCheck = false;
    self.validateForm.each(function() {

      $(this).validate({
          rules: {
              vaccineMonthCheck : {
                  required: {
                       depends: function (element) {
                           return ( $('#vaccineAgeCheck').val() < 1 );
                       }
                  }
              },
          },
          messages: {
              vaccineAgeCheck: {
                  required: '歳は必須入力です'
              },
              vaccineMonthCheck: {
                  required: '月齢は必須入力です'
              },
              resultDead: {
                  required: '症状の程度で「死亡」を選択した場合は、転帰も「死亡」を選択してください'
              },
              Symptom_Vaccine: {
                  required: 'この項目は必須入力です'
              },
              OthersSymptom1: {
                  required: '症状名1を記入してください'
              },
              OthersSymptom2: {
                  required: '症状名2を記入してください'
              },
              OthersSymptom3: {
                  required: '症状名3を記入してください'
              },
              OthersSymptom4: {
                  required: '症状名4を記入してください'
              },
              OthersSymptom5: {
                  required: '症状名5を記入してください'
              },
              OthersSymptom6: {
                  required: '症状名6を記入してください'
              },
              OthersSymptom7: {
                  required: '症状名7を記入してください'
              },
              OthersSymptom8: {
                  required: '症状名8を記入してください'
              },
              OthersSymptom9: {
                  required: '症状名9を記入してください'
              },
              OthersSymptom10: {
                  required: '症状名10を記入してください'
              },
          },
          errorPlacement: function(error,element){
              var mainContents = document.getElementById("main-content");
              var getFromDataCheck = element[0].form.id;
              if( element.attr("name") == "vaccineAgeCheck" ||
                  element.attr("name") == "vaccineMonthCheck" ){
                  error.insertAfter($('#'+element.attr('name')+'_err'));
                  var getFromData = element[0].form.id;
//                  var mainContents = document.getElementById("main-content");
                  if (getFromData == "patients") {
                    mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[3].childNodes[0].style.color = "#d42020";
                  }
              }else {
                  if( element.attr("name") == "Symptom_Vaccine" ) {
                     error.insertAfter($('#'+element.attr('name')+'_err'));
                  }else if( element.attr("name").indexOf('OthersSymptom') != -1){
                     error.insertBefore($('#Symptom_Vaccine_err'));
                  }else if( element.attr("name") == "result" ){
                     error.insertAfter($('#result_check_err'));
                  }else{
                    error.insertAfter(element);
                  }

              }
          },
        submitHandler: function() {
          var getCurrentTab = $('.tab-pane.active').attr('id');
          var mainContents = document.getElementById("main-content");
          if (getCurrentTab == "tab-1") {//rapporteur
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[1].childNodes[0].style.color = "white";
          }
          if (getCurrentTab == "tab-2") {//patients
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[3].childNodes[0].style.color = "white";
          }
          if (getCurrentTab == "tab-3") {//Vaccine
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[5].childNodes[0].style.color = "white";
          }
          if (getCurrentTab == "tab-4") {//VaccinationStatus
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[7].childNodes[0].style.color = "white";
          }
          if (getCurrentTab == "tab-5") {//symptoms
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[9].childNodes[0].style.color = "white";
          }
          if (getCurrentTab == "tab-6") {//opinion
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[11].childNodes[0].style.color = "white";
          }
          var currentNav = $('.change-tab[href="#' + getCurrentTab + '"]').parent();
          currentNav.next().find('a').trigger('click');
          $('body, html').animate({ scrollTop: 0 }, 200);
        },
        invalidHandler: function(error,element) {
          var getFromData = element.currentForm.id;
          var mainContents = document.getElementById("main-content");
          if (getFromData == "rapporteur") {
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[1].childNodes[0].style.color = "#d42020";
            errCheck = true;
          }
          if (getFromData == "patients") {
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[3].childNodes[0].style.color = "#d42020";
            errCheck = true;
          }
          if (getFromData == "vaccine") {
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[5].childNodes[0].style.color = "#d42020";
            errCheck = true;
          }
          if (getFromData == "vaccinationStatus") {
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[7].childNodes[0].style.color = "#d42020";
            errCheck = true;
          }
          if (getFromData == "symptom") {
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[9].childNodes[0].style.color = "#d42020";
            errCheck = true;
          }
          if (getFromData == "reporterOpinion") {
            mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[11].childNodes[0].style.color = "#d42020";
            errCheck = true;
          }
          if(allNotCheck){
            alert("この画面の入力内容に誤りがあります 赤いメッセージが出ている項目を確認してください");
          }
          //対応は不完全 4/16
//          var y = window.pageYOffset;
//          var x = window.pageXOffset;
//          $('body, html').animate({ y: x }, 200);
          $('body, html').animate({ scrollTop: 0 }, 200);
        },
      });
    });
  };
  
  // 4/16修正 No14
  blueShipLab.prototype.bindVaccinessNameChack = function() {
    //定期チェック
    var periodicCheck = false;
    for(var i =1;i<11;i++) {
      var periodic = document.getElementById("periodic_" + i);
      if ( periodic != null) {
        if (periodicCheck == false) {
          periodicCheck = periodic.checked;
        }
      }
    }
    if (periodicCheck) {
      var len = document.getElementsByName("Patients_nameInitials")[0].value.length;
      if (len == 1) {
        var content = document.getElementsByName("Patients_nameInitials")[0].value;
        var initialCheck = content.match(/[^A-Za-zＡ-Ｚａ-ｚ]+/);
        if (initialCheck == null) {
          var errObj = document.getElementById("Patients_nameInitials-err");
          errObj.innerText = "定期の場合は、イニシャルではなく氏名を入力してください";
          errObj.style.display = "";
          return false;
        }
      }
    }
    var errObj = document.getElementById("Patients_nameInitials-err");
    errObj.innerText = "";
    errObj.style.display = "none";
    return true;
  };

  // 4/16修正 No14
  blueShipLab.prototype.bindVaccinessLastNameChack = function() {
    //定期チェック
    var periodicCheck = false;
    for(var i =1;i<11;i++) {
      var periodic = document.getElementById("periodic_" + i);
      if ( periodic != null) {
        if (periodicCheck == false) {
          periodicCheck = periodic.checked;
        }
      }
    }
    if (periodicCheck) {
      var len = document.getElementsByName("Patients_lastnameInitials")[0].value.length;
      if (len == 1) {
        var content = document.getElementsByName("Patients_lastnameInitials")[0].value;
        var initialCheck = content.match(/[^A-Za-zＡ-Ｚａ-ｚ]+/);
        if (initialCheck == null) {
          var errObj = document.getElementById("Patients_lastnameInitials-err");
          errObj.innerText = "定期の場合は、イニシャルではなく氏名を入力してください";
          errObj.style.display = "";
          return false;
        }
      }
    }
    var errObj = document.getElementById("Patients_lastnameInitials-err");
    errObj.innerText = "";
    errObj.style.display = "none";
    return true;
  };
  
  blueShipLab.prototype.bindAgeValidate = function() {

   var self = this;
        var lastVaccineDayFromBirth = self.getLastVaccineDayFromBirth();
        var year = $('#vaccineAgeCheck').val();
        if ( !isNaN(lastVaccineDayFromBirth.year) ) {
            if( year != lastVaccineDayFromBirth.year ){
                document.getElementById("vaccineAgeCheck_err").innerText = "接種時の年齢に誤りがあります"
                return false;
            }
            var month = $('#vaccineMonthCheck').val();
            if( month != "" && month != lastVaccineDayFromBirth.surplus ){
                document.getElementById("vaccineMonthCheck_err").innerText = "接種時の月齢に誤りがあります"
                return false;
            }
        }
        document.getElementById("vaccineAgeCheck_err").innerText = ""
        document.getElementById("vaccineMonthCheck_err").innerText = ""
        return true;
  };
  
  blueShipLab.prototype.symptomCheck = function() {
    var self = this;
    self.checkSymptomNum.on('click',function(e) {
      var sympBox = document.getElementsByName("Symptom_Vaccine");
      var sympLen = sympBox.length;
      var chkCnt = 0;
      for(var i=0;i<sympLen;i++){
        if ( document.getElementsByName("Symptom_Vaccine")[i].checked ) {
          chkCnt = chkCnt + 1;
        }
      }
      var checkNm = this.value;
      if (chkCnt > 14) {
        var valueName = this.value;
        var userAgent = window.navigator.userAgent.toLowerCase();
        if (valueName.indexOf("Other") != -1){
          if (userAgent.indexOf('trident/7.0') > -1) {
            document.getElementById(valueName).disabled = true;
          }else if (userAgent.indexOf('msie') > -1) {
            document.getElementById(valueName).disabled = true;
          }else if (userAgent.indexOf('edge') > -1) {
            document.getElementById(valueName).disabled = true;
          }else if (userAgent.indexOf('safari') > -1) {
            document.getElementById(valueName).disabled = true;
          }else{
            document.getElementById(valueName).disabled = false;
          }
        }
        this.checked = false;
        document.getElementById("Symptom_Vaccine_err").innerText = "症状は14個以内で選択してください"
      }else{
        document.getElementById("Symptom_Vaccine_err").innerText = ""
      }
    });
  };
  
  blueShipLab.prototype.symptomCheckOthers = function() {
    var self = this;
    self.checkSymptomNumOthers.on('click',function(e) {
      var sympBox = document.getElementsByName("Symptom_Vaccine");
      var sympLen = sympBox.length;
      var chkCnt = 0;
      for(var i=0;i<sympLen;i++){
        if ( document.getElementsByName("Symptom_Vaccine")[i].checked ) {
          chkCnt = chkCnt + 1;
        }
      }
      var checkNm = this.value;
      if (chkCnt > 14) {
        var valueName = this.value;
        var userAgent = window.navigator.userAgent.toLowerCase();
        if (valueName.indexOf("Other") != -1){
          if (userAgent.indexOf('trident/7.0') > -1) {
            document.getElementById(valueName).disabled = true;
          }else if (userAgent.indexOf('msie') > -1) {
            document.getElementById(valueName).disabled = true;
          }else if (userAgent.indexOf('edge') > -1) {
            document.getElementById(valueName).disabled = true;
          }else if (userAgent.indexOf('safari') > -1) {
            document.getElementById(valueName).disabled = true;
          }else{
            document.getElementById(valueName).disabled = false;
          }
        }
        this.checked = false;
        document.getElementById("Symptom_Vaccine_err").innerText = "症状は14個以内で選択してください"
      }else{
        document.getElementById("Symptom_Vaccine_err").innerText = ""
      }
    });
  };
  
  blueShipLab.prototype.bindSavePrintf = function() {
    
    var self = this;
    var objIni = document.getElementById("anchor");
    objIni.innerText = "";
    objIni.style.display = "none";
    var objPcheck = document.getElementById("print_check");
    objPcheck.value ="false";

    self.btnSavePrintf.on('click', function(e) {
      var mainContents = document.getElementById("main-content");
      //rapporteur
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[1].childNodes[0].style.color = "white";
      //patients
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[3].childNodes[0].style.color = "white";
      //Vaccine
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[5].childNodes[0].style.color = "white";
      //VaccinationStatus
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[7].childNodes[0].style.color = "white";
      //symptoms
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[9].childNodes[0].style.color = "white";
      //opinion
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[11].childNodes[0].style.color = "white";
      var Default = true;
      allNotCheck = false;
        self.validateForm.each(function(i,elem) {
        if ($(this).valid() != true) {
          var check = elem.id;
          var mainContents = document.getElementById("main-content");
          if (check == "rapporteur") {
             mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[1].childNodes[0].style.color = "#d42020";
          }
          if (check == "patients") {
             mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[3].childNodes[0].style.color = "#d42020";
          }
          if (check == "vaccine") {
             mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[5].childNodes[0].style.color = "#d42020";
          }
          if (check == "vaccinationStatus") {
             mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[7].childNodes[0].style.color = "#d42020";
          }
          if (check == "symptom") {
             mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[9].childNodes[0].style.color = "#d42020";
          }
          if (check == "reporterOpinion") {
             mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[11].childNodes[0].style.color = "#d42020";
          }
          Default = false;
        }
      });
      allNotCheck = true;
      var ageCheck = self.bindAgeValidate();
      // 4/16修正
      var nameCheck = self.bindVaccinessNameChack();
      var lastNameCheck = self.bindVaccinessLastNameChack();
      var termCheck = self.getOccursDateFromLast();
      if (nameCheck == false || lastNameCheck == false || ageCheck == false) {
        mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[3].childNodes[0].style.color = "#d42020";
      }
      if (termCheck == false) {
        mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[9].childNodes[0].style.color = "#d42020";
      }
      if (Default && ageCheck && nameCheck && lastNameCheck && termCheck) {
      var objCkOk = document.getElementById("print_check");
      objCkOk.value ="true";

      var $this = $(this);
      var dataFile = '';
      var time = new Date();
      var strYear = time.getFullYear();
      strYear = String(strYear).substr(String(strYear).length-2,2)
      var strMth = time.getMonth()+1;
      if (strMth < 10) {
        strMth = "0"+strMth;
      }
      var strDay = time.getDate();
      if (strDay < 10) {
        strDay = "0"+strDay;
      }
      var strHour = time.getHours();
      if (strHour < 10) {
        strHour = "0"+strHour;
      }
      var strMin = time.getMinutes();
      if (strMin < 10) {
        strMin = "0"+strMin;
      }
      var strSec = time.getSeconds();
      if (strSec < 10) {
        strSec = "0"+strSec;
      }
      var strDate = strYear + "a" + strMth + "a" + strDay + "a_" +strHour + "a" + strMin + "a" + strSec;
      strDate = strDate.replace(/a/g,"");
      var retVal = {};
      var ReporterNm = document.getElementById('RapporteurName').value;
      if (ReporterNm == null || ReporterNm == "") {
        ReporterNm = "DrName";
      }
      var age = document.getElementById('vaccineAgeCheck').value;
      if ( age =='' ) {
        age = '999';
      }else if(age < 10){
        age = "00" + age;
      }else if(age < 99){
        age = "0" + age;
      }
      var sexlist = document.getElementsByName('Patients_sex');
      var sex = 'N'
      for(var i=0;i<sexlist.length;i++){
        if (sexlist[i].checked) {
          if (sexlist[i].value=='Patients_male') {
            sex='M'
          }else if (sexlist[i].value=='Patients_female') {
            sex='F'
          }else{
            sex='N'
          }
        }
      }
      var countForm = 1;
      self.validateForm.each(function() {
        var $this = $(this);
        var results = $this.serializeArray();

        var form_index = 'form_' + countForm;

        retVal[form_index] = results;

        countForm++;
      });
      retVal = JSON.stringify(retVal);
      var userAgent = window.navigator.userAgent.toLowerCase();
      if (userAgent.indexOf('trident/7.0') > -1) {
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'印刷用保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json');
        alert("ダウンロードフォルダへ保存します\n" +
        "保存したファイルは「データ保存」フォルダへの移動をお勧めします\n\n"+
        "保存したファイルから報告書（PDFファイル）を作成するためには\n"+
        "javaをインストールする必要があります\n\nインストール方法は操作マニュアルをご覧ください");
        e.preventDefault(); 
      }else if (userAgent.indexOf('msie') > -1) {
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'印刷用保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json');
        alert("ダウンロードフォルダへ保存します\n" +
        "保存したファイルは「データ保存」フォルダへの移動をお勧めします\n\n"+
        "保存したファイルから報告書（PDFファイル）を作成するためには\n"+
        "javaをインストールする必要があります\n\nインストール方法は操作マニュアルをご覧ください");
        e.preventDefault(); 
      }else if (userAgent.indexOf('edge') > -1) {
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'印刷用保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json');
        alert("ダウンロードフォルダへ保存します\n" +
        "保存したファイルは「データ保存」フォルダへの移動をお勧めします\n\n"+
        "保存したファイルから報告書（PDFファイル）を作成するためには\n"+
        "javaをインストールする必要があります\n\nインストール方法は操作マニュアルをご覧ください");
        e.preventDefault(); 
      }else if (userAgent.indexOf('chrome') != -1) {
        $this.attr({
          download: '印刷用保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json',
          href: "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal)
        });
        alert("ダウンロードフォルダへ保存します\n" +
        "保存したファイルは「データ保存」フォルダへの移動をお勧めします\n\n"+
        "保存したファイルから報告書（PDFファイル）を作成するためには\n"+
        "javaをインストールする必要があります\n\nインストール方法は操作マニュアルをご覧ください");
      }else if (userAgent.indexOf('safari') != -1) {
        $this.attr({
          download: '印刷用保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json',
          href: "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal)
        });
        alert("ダウンロードフォルダへ保存します\n" +
        "保存したファイルは「データ保存」フォルダへの移動をお勧めします\n\n"+
        "保存したファイルから報告書（PDFファイル）を作成するためには\n"+
        "javaをインストールする必要があります\n\nインストール方法は操作マニュアルをご覧ください");
      }
      var obj = document.getElementById("anchor");
      obj.innerText = "";
      obj.style.display = "none";
    }else{ 
      var obj = document.getElementById("anchor");
      obj.innerText = "タブの文字の色が白から赤に変わっている画面の入力内容に誤りがあります " +
      "赤いメッセージが出ている項目を確認してください";
      obj.style.display = "";
      e.preventDefault(); 
      alert("タブの文字の色が白から赤に変わっている画面の入力内容に誤りがあります\n"+
      "赤いメッセージが出ている項目を確認してください");
      } //チェックが通らなかったら

    });
    

  };
  
  blueShipLab.prototype.bindPrintf = function() {
    var self = this;
    self.btnPrintf.on('click', function(e) {
      var $this = $(this);

      var Default = true;
      if (Default) {

        var userAgent = window.navigator.userAgent.toLowerCase();
//        var blob = new Blob([retVal],{type:"text/plain"});
        if (userAgent.indexOf('trident/7.0') > -1) {
 //         wshshell = new ActiveXObject("WScript.Shell");
 //         wshshell.Exec("./jar/test.bat retVal");
 //         window.navigator.msSaveBlob(blob,'data.json');
        }else if (userAgent.indexOf('chrome') != -1) {
//        $this.attr({
//          href: "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal)
//        });
//            window.open("./jar/pdfOutput.jar"); 使えない
//            wshshell = new ActiveXObject("WScript.Shell"); 使えない
//          var obj = document.getElementById("anchor");
//          obj.href = "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal);
//          obj.innerHTML = "この部分を右クリックで保存して下さい";
        }
//        window.print();
      }
    });
  };

  blueShipLab.prototype.saveData = function() {
    var self = this;

    self.btnSaveData.on('click', function() {
      var $this = $(this);
      var dataFile = '';
      var objPcheck = document.getElementById("print_check");
      objPcheck.value ="false";
      var time = new Date();
      var strYear = time.getFullYear();
      strYear = String(strYear).substr(String(strYear).length-2,2)
      var strMth = time.getMonth()+1;
      if (strMth < 10) {
        strMth = "0"+strMth;
      }
      var strDay = time.getDate();
      if (strDay < 10) {
        strDay = "0"+strDay;
      }
      var strHour = time.getHours();
      if (strHour < 10) {
        strHour = "0"+strHour;
      }
      var strMin = time.getMinutes();
      if (strMin < 10) {
        strMin = "0"+strMin;
      }
      var strSec = time.getSeconds();
      if (strSec < 10) {
        strSec = "0"+strSec;
      }
      var strDate = strYear + "a" + strMth + "a" + strDay + "a_" +strHour + "a" + strMin + "a" + strSec;
      strDate = strDate.replace(/a/g,"");
      var retVal = {};
      var ReporterNm = document.getElementById('RapporteurName').value;
      if (ReporterNm == null || ReporterNm == "") {
        ReporterNm = "DrName";
      }
      var age = document.getElementById('vaccineAgeCheck').value;
      if ( age =='' ) {
        age = '999';
      }else if(age < 10){
        age = "00" + age;
      }else if(age < 99){
        age = "0" + age;
      }
      var sexlist = document.getElementsByName('Patients_sex');
      var sex = 'N'
      for(var i=0;i<sexlist.length;i++){
        if (sexlist[i].checked) {
          if (sexlist[i].value=='Patients_male') {
            sex='M'
          }else if (sexlist[i].value=='Patients_female') {
            sex='F'
          }else{
            sex='N'
          }
        }
      }



      var countForm = 1;
      self.validateForm.each(function() {
        var $this = $(this);
        var results = $this.serializeArray();

        var form_index = 'form_' + countForm;

        retVal[form_index] = results;

        countForm++;
      });
      retVal = JSON.stringify(retVal);
      var userAgent = window.navigator.userAgent.toLowerCase();
      if (userAgent.indexOf('trident/7.0') > -1) {
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'一時保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json');
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
      }else if (userAgent.indexOf('msie') > -1) {
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'一時保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json');
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
      }else if (userAgent.indexOf('edge') > -1) {
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'一時保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json');
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
      }else if (userAgent.indexOf('chrome') != -1) {
        $this.attr({
          download: '一時保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json',
          href: "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal)
        });
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
//          var obj = document.getElementById("anchor");
//          obj.href = "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal);
//          obj.innerHTML = "この部分を右クリックで保存して下さい";
      }else if (userAgent.indexOf('safari') != -1) {
        $this.attr({
          download: '一時保存_' + ReporterNm + '_'+ age +'_'+ sex +'_'+ strDate +'.json',
          href: "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal)
        });
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
//          var obj = document.getElementById("anchor");
//          obj.href = "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal);
//          obj.innerHTML = "この部分を右クリックで保存して下さい";
      }

    });
  };

  blueShipLab.prototype.loadData = function() {
    var self = this;
    var loop = function($loopCnt) {
      var content = event.target.result;
      var contentJSON = $.parseJSON(content);

      for (var formIndex in contentJSON) {
        var formData = contentJSON[formIndex];
        var othersSymptomsCount = 0;

        for (inputIndex in formData) {
           var name = formData[inputIndex]['name'];
           var value = formData[inputIndex]['value'];
            if(name == "Symptom_Vaccine" && value.indexOf("Others") !== -1){
                othersSymptomsCount += 1;
            }

            if (name.indexOf("OthersSymptom") !== -1){
            }
        }

        for (var inputIndex in formData) {
          var name = formData[inputIndex]['name'];
          var value = formData[inputIndex]['value'];
          var continueFlag = false;
          if(name == "Symptom_Vaccine" && value.indexOf("Others") !== -1){
            for (var i in formData) {
                var n = formData[i]['name'];
                if(n == "OthersSymptom" + value.split("Others")[1] ) {
                  var OtherSymtomVal =  formData[i]['value'];
                  $.each( symptoms_name, function( key, valueLoopVal ) {
                     for (var nameIndex in valueLoopVal) {
                          if(valueLoopVal[nameIndex] == OtherSymtomVal){
                             if($('[name="' + name + '"][type="checkbox"][value="' + key + '"]').length){
                                 $('[name="' + name + '"][type="checkbox"][value="' + key + '"]').prop('checked', true).change();
                                   document.getElementById(value).disabled = true;
                                   document.getElementById(value).value = "";
                                   continueFlag = true;
                                   break;

                               }else if ( $('[name="' + name + '"][type="checkbox"][value="lr_' + key + '"]').length ) {
                                key = "lr_" + key;
                                $('[name="' + name + '"][type="checkbox"][value="' + key + '"]').prop('checked', true).change();
                                document.getElementById(value).disabled = true;
                                document.getElementById(value).value = "";
                                continueFlag = true;
                                break;
                               }

                          }
                      }
                      if(continueFlag){
                        return false;
                      }

                  });
                  if($('[name="' + name + '"][type="checkbox"][value="' + OtherSymtomVal + '"]').length){
                      $('[name="' + name + '"][type="checkbox"][value="' + OtherSymtomVal + '"]').prop('checked', true).change();

                      document.getElementById(value).disabled = true;
                      document.getElementById(value).value = "";
                      continueFlag = true;
                    }else if ( $('[name="' + name + '"][type="checkbox"][value="lr_' + OtherSymtomVal + '"]').length ) {
                      $('[name="' + name + '"][type="checkbox"][value="lr_' + OtherSymtomVal + '"]').prop('checked', true).change();

                      document.getElementById(value).disabled = true;
                      document.getElementById(value).value = "";
                      continueFlag = true;
                    }

                  if(continueFlag){
                   delete formData[i];
                    othersSymptomsCount --;
                  }
                  break;
                }
            }
          }

          if(continueFlag){
            continue;
          }

          if (name.lastIndexOf('cVac_',0) == 0 && name != 'cVac_1' && $loopCnt == 0) {
            var cloneEvent = document.getElementById("btn_clone");
            cloneEvent.click();
          }
          if ($('[name="' + name + '"]').attr('type') == 'text' || $('[name="' + name + '"]').is('textarea')  ) {
            $('[name="' + name + '"]').val(value);
            if (name == 'adem4-1') {
              document.getElementById('adem4-1').disabled = false;//強制オープン
            }
          } else if ($('[name="' + name + '"]').attr('type') == 'hidden' && $loopCnt == 1) {
            if (name == 'brightonCriteriaAdem') {
              $('[name="' + name + '"]').val(value);
              document.getElementById('brightonCriteriaAdem').disabled = false;
              document.getElementById("brightonCriteriaAdeminput").innerText = value;
            }
            if (name == 'brightonCriteriaGBS') {
              $('[name="' + name + '"]').val(value);
              document.getElementById('brightonCriteriaGBS').disabled = false;
              document.getElementById("brightonCriteriaGBSinput").innerText = value;
            }
            // ▼▼▼
            if (name == 'brightonCriteriatts') {
              $('[name="' + name + '"]').val(value);
              document.getElementById('brightonCriteriatts').disabled = false;
              document.getElementById("brightonCriteriattsinput").innerText = value;
            }
            if (name == 'brightonCriteriaMyo') {
              $('[name="' + name + '"]').val(value);
              document.getElementById('brightonCriteriaMyo').disabled = false;
              document.getElementById("brightonCriteriaMyoinput").innerText = value;
            }
            if (name == 'brightonCriteriaPer') {
              $('[name="' + name + '"]').val(value);
              document.getElementById('brightonCriteriaPer').disabled = false;
              document.getElementById("brightonCriteriaPerinput").innerText = value;
            }
            if (name == 'tts1-38') {
              $('[name="' + name + '"]').val(value);
              document.getElementById('tts1-38').disabled = false;
              document.getElementById("min_onsetdays_lbl").innerText = value;
            }
            if (name == 'myo2-19') {
              $('[name="' + name + '"]').val(value);
              document.getElementById('myo2-19').disabled = false;
              document.getElementById("min_onsetdays_lbl_myo").innerText = value;
            }
            if (name == 'per2-07') {
              $('[name="' + name + '"]').val(value);
              document.getElementById('per2-07').disabled = false;
              document.getElementById("min_onsetdays_lbl_per").innerText = value;
            }
            // ▲▲▲
          } else if ($('[name="' + name + '"]').attr('type') == 'radio' && $loopCnt == 0) {
            $('[name="' + name + '"][type="radio"][value="' + value + '"]').prop('checked', true).trigger('change');
            var radioCheck = $('[name="' + name + '"][type="radio"][value="' + value + '"]');
            if (name=="tts2-04" && value=="陽性") {
              document.getElementById('tts2-04-a').disabled = false;
            }
            if (name=="tts2-05" && value=="陽性") {
              document.getElementById('tts2-05-a').disabled = false;
            }
            if (name =='myo3-01' || name =='myo3-02' || name =='myo3-03' || name =='myo3-04' || name =='myo3-05' || name =='myo3-06' || name =='myo3-07' || name =='myo3-08') {
              closeUnderInspection(name);
            }
            if (name =='per3-01' || name =='per3-02' || name =='per3-03' || name =='per3-04' || name =='per3-05' || name =='per3-06' || name =='per3-07' || name =='per3-08') {
              closeUnderInspection(name);
            }
          } else if ($('[name="' + name + '"]').attr('type') == 'radio' && $loopCnt == 1 && name == 'adem4') {
            $('[name="' + name + '"][type="radio"][value="' + value + '"]').prop('checked', true).trigger('change');
//          } else if ($('[name="' + name + '"]').attr('type') == 'radio' && $loopCnt == 1 && name == 'adem5') {
//            $('[name="' + name + '"][type="radio"][value="' + value + '"]').prop('checked', true).trigger('change');
//            ademForSelectMessageDisplay()
          } else if ($('[name="' + name + '"]').attr('type') == 'checkbox' && $loopCnt == 1) {
            if (value.indexOf('急性散在性脳脊髄炎（ADEM)') != -1) {
              document.getElementById('ademInputForm').style.display = "block";
            }
            if(value.indexOf('ギラン・バレ症候群') != -1){
              document.getElementById('gbsInputForm').style.display = "block";
            }
            // ▼▼▼
            if(value.indexOf('血栓症（血栓塞栓症を含む。）（血小板減少症を伴うものに限る。）') != -1){
              document.getElementById('ttsInputForm').style.display = "block";
            }
            if(value.indexOf('心筋炎') != -1){
              document.getElementById('myoInputForm').style.display = "block";
            }
            if(value.indexOf('心膜炎') != -1){
              document.getElementById('perInputForm').style.display = "block";
            }
            // ▲▲▲
            if (name == 'stageDetails' ) {
              var stagebox = document.getElementById(value);
              stagebox.click();
            }else if (name == 'adem1-1' && value == 'adem1-2') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              document.getElementById('adem1-2-1').disabled = false;
            }else if (name == 'adem2-a1' && value == 'adem2-a1') {
              checkBoxCheckAndAble ( document.getElementById(value) );
            }else if (name == 'adem2-a2' && value == 'adem2-a2') {
              checkBoxCheckAndAble ( document.getElementById(value) );
            }else if (name == 'adem2-a2-1' && value == 'adem2-a2-1') {
              checkBoxCheckAndAble ( document.getElementById(value) );
            }else if (name == 'adem2-a2-1-a') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              if (value == 'adem2-a2-1-7') {
                document.getElementById('adem2-a2-1-7-1').disabled = false;
              }
            }else if (name == 'adem2-a3' && value == 'adem2-a3') {
              checkBoxCheckAndAble ( document.getElementById(value) );
            }else if (name == 'adem2-a4' && value == 'adem2-a4') {
              checkBoxCheckAndAble ( document.getElementById(value) );
            }else if (name == 'adem2-a5' && value == 'adem2-a5') {
              document.getElementById('adem2-a5').click();
            }else if (name == 'adem2-2') {
              if ( value == 'adem2-2-11' ) {
                document.getElementById(value).click();
              }else{
                checkBoxCheckAndAble ( document.getElementById(value) );
                if (value == 'adem2-2-10') {
                  document.getElementById('adem2-2-10-1').disabled = false;
                }
              }
            }else if (name == 'adem3-2' && value == 'adem3-5') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              document.getElementById('adem3-5-1').disabled = false;
            }else if (name == 'adem5-2') {
              if ( value == 'adem5-2-4' || value == 'adem5-2-5') {
                document.getElementById(value).click();
              }else{
                checkBoxCheckAndAble ( document.getElementById(value) );
              }
            }else if (name == 'adem7-5' && value == 'adem7-5') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              document.getElementById('adem7-5-1').disabled = false;
              
              
            }else if (name == 'gbs1-2' && value == 'gbs1-2') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-gbs11').disabled = false;
              document.getElementById('month-gbs11').disabled = false;
              document.getElementById('days-gbs11').disabled = false;
            }else if (name == 'gbs1-3') {
              checkBoxCheckAndAble ( document.getElementById(value) );
            }else if (name == 'gbs1-4' && value == 'gbs1-4-1') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              normalCheck(document.getElementById('gbs1-4-1'))
            }else if (name == 'gbs1-5') {
              document.getElementById(value).click();
            }else if (name == 'gbs2-1' && value == 'gbs2-1-2') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              document.getElementById('gbs2-1-2-1').disabled = false;
            }else if (name == 'gbs3-2-2-8' && value == 'gbs3-2-2-8') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              document.getElementById('gbs3-2-2-8-1').disabled = false;
            }else if (name == 'gbs6-5' && value == 'gbs6-5') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              document.getElementById('gbs6-5-1').disabled = false;
            }else if (name == 'gbs7-5' && value == 'gbs7-5') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              document.getElementById('gbs7-5-1').disabled = false;
            }else if (name == 'gbs8-6' && value == 'gbs8-6') {
              $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              document.getElementById('gbs8-6-1').disabled = false;
              
	        // ▼▼▼
            }else if (name == 'tts1-01' && value == 'tts1-01') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-01').disabled = false;
              document.getElementById('month-tts1-01').disabled = false;
              document.getElementById('days-tts1-01').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-02') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-02').disabled = false;
              document.getElementById('month-tts1-02').disabled = false;
              document.getElementById('days-tts1-02').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-03') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-03').disabled = false;
              document.getElementById('month-tts1-03').disabled = false;
              document.getElementById('days-tts1-03').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-04') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-04').disabled = false;
              document.getElementById('month-tts1-04').disabled = false;
              document.getElementById('days-tts1-04').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-05') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-05').disabled = false;
              document.getElementById('month-tts1-05').disabled = false;
              document.getElementById('days-tts1-05').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-06') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-06').disabled = false;
              document.getElementById('month-tts1-06').disabled = false;
              document.getElementById('days-tts1-06').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-07') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-07').disabled = false;
              document.getElementById('month-tts1-07').disabled = false;
              document.getElementById('days-tts1-07').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-08') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-08').disabled = false;
              document.getElementById('month-tts1-08').disabled = false;
              document.getElementById('days-tts1-08').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-09') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-09').disabled = false;
              document.getElementById('month-tts1-09').disabled = false;
              document.getElementById('days-tts1-09').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-10') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-10').disabled = false;
              document.getElementById('month-tts1-10').disabled = false;
              document.getElementById('days-tts1-10').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-11') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-11').disabled = false;
              document.getElementById('month-tts1-11').disabled = false;
              document.getElementById('days-tts1-11').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-12') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-12').disabled = false;
              document.getElementById('month-tts1-12').disabled = false;
              document.getElementById('days-tts1-12').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-13') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-13').disabled = false;
              document.getElementById('month-tts1-13').disabled = false;
              document.getElementById('days-tts1-13').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-14') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-14').disabled = false;
              document.getElementById('month-tts1-14').disabled = false;
              document.getElementById('days-tts1-14').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-15') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-15').disabled = false;
              document.getElementById('month-tts1-15').disabled = false;
              document.getElementById('days-tts1-15').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-16') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-16').disabled = false;
              document.getElementById('month-tts1-16').disabled = false;
              document.getElementById('days-tts1-16').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-17') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-17').disabled = false;
              document.getElementById('month-tts1-17').disabled = false;
              document.getElementById('days-tts1-17').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-18') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-18').disabled = false;
              document.getElementById('month-tts1-18').disabled = false;
              document.getElementById('days-tts1-18').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-19') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-19').disabled = false;
              document.getElementById('month-tts1-19').disabled = false;
              document.getElementById('days-tts1-19').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-20') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-20').disabled = false;
              document.getElementById('month-tts1-20').disabled = false;
              document.getElementById('days-tts1-20').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-21') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-21').disabled = false;
              document.getElementById('month-tts1-21').disabled = false;
              document.getElementById('days-tts1-21').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-22') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-22').disabled = false;
              document.getElementById('month-tts1-22').disabled = false;
              document.getElementById('days-tts1-22').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-23') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-23').disabled = false;
              document.getElementById('month-tts1-23').disabled = false;
              document.getElementById('days-tts1-23').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-24') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-24').disabled = false;
              document.getElementById('month-tts1-24').disabled = false;
              document.getElementById('days-tts1-24').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-25') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-25').disabled = false;
              document.getElementById('month-tts1-25').disabled = false;
              document.getElementById('days-tts1-25').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-26') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-26').disabled = false;
              document.getElementById('month-tts1-26').disabled = false;
              document.getElementById('days-tts1-26').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-27') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-27').disabled = false;
              document.getElementById('month-tts1-27').disabled = false;
              document.getElementById('days-tts1-27').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-28') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-28').disabled = false;
              document.getElementById('month-tts1-28').disabled = false;
              document.getElementById('days-tts1-28').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-29') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-29').disabled = false;
              document.getElementById('month-tts1-29').disabled = false;
              document.getElementById('days-tts1-29').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-30') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-30').disabled = false;
              document.getElementById('month-tts1-30').disabled = false;
              document.getElementById('days-tts1-30').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-31') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-31').disabled = false;
              document.getElementById('month-tts1-31').disabled = false;
              document.getElementById('days-tts1-31').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-32') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-32').disabled = false;
              document.getElementById('month-tts1-32').disabled = false;
              document.getElementById('days-tts1-32').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-33') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-33').disabled = false;
              document.getElementById('month-tts1-33').disabled = false;
              document.getElementById('days-tts1-33').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-34') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-34').disabled = false;
              document.getElementById('month-tts1-34').disabled = false;
              document.getElementById('days-tts1-34').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-35') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-35').disabled = false;
              document.getElementById('month-tts1-35').disabled = false;
              document.getElementById('days-tts1-35').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-36') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-36').disabled = false;
              document.getElementById('month-tts1-36').disabled = false;
              document.getElementById('days-tts1-36').disabled = false;
            }else if (name == 'tts1-01' && value == 'tts1-37') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              document.getElementById('year-tts1-37').disabled = false;
              document.getElementById('month-tts1-37').disabled = false;
              document.getElementById('days-tts1-37').disabled = false;
              document.getElementById('tts1-37-1').disabled = false;
            }else if (name == 'tts2-01' && value == 'tts2-01') {
              document.getElementById('year-tts2-01').disabled = false;
              document.getElementById('month-tts2-01').disabled = false;
              document.getElementById('days-tts2-01').disabled = false;
            }else if (name == 'tts2-04' && value == 'tts2-04') {
              document.getElementById('year-tts2-04').disabled = false;
              document.getElementById('month-tts2-04').disabled = false;
              document.getElementById('days-tts2-04').disabled = false;
            }else if (name == 'tts2-05' && value == 'tts2-05') {
              document.getElementById('year-tts2-05').disabled = false;
              document.getElementById('month-tts2-05').disabled = false;
              document.getElementById('days-tts2-05').disabled = false;
            }else if (name == 'tts2-06' && value == 'tts2-06') {
              document.getElementById('year-tts2-06').disabled = false;
              document.getElementById('month-tts2-06').disabled = false;
              document.getElementById('days-tts2-06').disabled = false;
            }else if (name == 'tts2-07' && value == 'tts2-07') {
              document.getElementById('year-tts2-07').disabled = false;
              document.getElementById('month-tts2-07').disabled = false;
              document.getElementById('days-tts2-067').disabled = false;
            }else if (name == 'tts3-01' && value == 'tts3-01') {
              document.getElementById('year-tts3-01').disabled = false;
              document.getElementById('month-tts3-01').disabled = false;
              document.getElementById('days-tts3-01').disabled = false;
            }else if (name == 'tts3-02' && value == 'tts3-02') {
              document.getElementById('year-tts3-02').disabled = false;
              document.getElementById('month-tts3-02').disabled = false;
              document.getElementById('days-tts3-02').disabled = false;
            }else if (name == 'tts3-03' && value == 'tts3-03') {
              document.getElementById('year-tts3-03').disabled = false;
              document.getElementById('month-tts3-03').disabled = false;
              document.getElementById('days-tts3-03').disabled = false;
            }else if (name == 'tts3-04' && value == 'tts3-04') {
              document.getElementById('year-tts3-04').disabled = false;
              document.getElementById('month-tts3-04').disabled = false;
              document.getElementById('days-tts3-04').disabled = false;
            }else if (name == 'tts3-05' && value == 'tts3-05') {
              document.getElementById('year-tts3-05').disabled = false;
              document.getElementById('month-tts3-05').disabled = false;
              document.getElementById('days-tts3-05').disabled = false;
            }else if (name == 'tts3-06' && value == 'tts3-06') {
              document.getElementById('year-tts3-06').disabled = false;
              document.getElementById('month-tts3-06').disabled = false;
              document.getElementById('days-tts3-06').disabled = false;
            }else if (name == 'tts3-07' && value == 'tts3-07') {
              document.getElementById('year-tts3-07').disabled = false;
              document.getElementById('month-tts3-07').disabled = false;
              document.getElementById('days-tts3-07').disabled = false;
            }else if (name == 'tts4-01' && value == 'tts4-01') {
              document.getElementById('year-tts4-01').disabled = false;
              document.getElementById('month-tts4-01').disabled = false;
              document.getElementById('days-tts4-01').disabled = false;
            }else if (name == 'tts4-02' && value == 'tts4-02') {
              document.getElementById('year-tts4-02').disabled = false;
              document.getElementById('month-tts4-02').disabled = false;
              document.getElementById('days-tts4-02').disabled = false;
            }else if (name == 'tts5-03' && value == 'tts5-03') {
              document.getElementById('year-tts5-03').disabled = false;
              document.getElementById('month-tts5-03').disabled = false;
              document.getElementById('days-tts5-03').disabled = false;
            }else if (name == 'tts5-04' && value == 'tts5-04') {
              document.getElementById('year-tts5-04').disabled = false;
              document.getElementById('month-tts5-04').disabled = false;
              document.getElementById('days-tts5-04').disabled = false;
            }else if (name == 'tts2-06-1') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              if (value == 'tts2-06-4') {
                document.getElementById('tts2-06-5').disabled = false;
              }
            }else if (name == 'tts3-01-1') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              if (value == 'tts3-01-5') {
                document.getElementById('tts3-01-6').disabled = false;
              }
            }else if (name == 'tts3-02-2') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              if (value == 'tts3-02-7') {
                document.getElementById('tts3-02-8').disabled = false;
              }
            }else if (name == 'tts3-03-2') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              if (value == 'tts3-03-7') {
                document.getElementById('tts3-03-8').disabled = false;
              }
            }else if (name == 'tts5-01') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              if (value == 'tts5-01-8') {
                document.getElementById('tts5-01-9').disabled = false;
              }
            }else if (name == 'tts5-02-1') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              if (value == 'tts5-02-7') {
                document.getElementById('tts5-02-8').disabled = false;
              }
            }else if (name == 'tts5-05-1') {
              checkBoxCheckAndAble ( document.getElementById(value) );
              if (value == 'tts5-05-9') {
                document.getElementById('tts5-05-10').disabled = false;
              }else if (value == 'tts5-05-11') {
                document.getElementById('tts5-05-12').disabled = false;
              }else if (value == 'tts5-05-13') {
                document.getElementById('tts5-05-14').disabled = false;
              }else if (value == 'tts5-05-15') {
                document.getElementById('tts5-05-16').disabled = false;
              }else if (value == 'tts5-05-17') {
                document.getElementById('tts5-05-18').disabled = false;
              }else if (value == 'tts5-05-19') {
                document.getElementById('tts5-05-20').disabled = false;
              }else if (value == 'tts5-05-21') {
                document.getElementById('tts5-05-22').disabled = false;
              }else if (value == 'tts5-05-23') {
                document.getElementById('tts5-05-24').disabled = false;
              }else if (value == 'tts5-05-25') {
                document.getElementById('tts5-05-26').disabled = false;
              }else if (value == 'tts5-05-27') {
                document.getElementById('tts5-05-28').disabled = false;
              }
	        // ▲▲▲
              
            }else if(name.indexOf("myo") > -1){
              // fill myo data from json
              mapMyoCheckbox(name,value);
            }else if(name.indexOf("per") > -1){
              mapPerCheckbox(name,value);

            }else {
               value = value.replace('lr_','');
              if($('[name="' + name + '"][type="checkbox"][value="' + value + '"]').length){
                    $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              }else if ( $('[name="' + name + '"][type="checkbox"][value="lr_' + value + '"]').length ) {
                    value = "lr_" + value;
                    $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').prop('checked', true).change();
              }else {
                    if(othersSymptomsCount <10){
                            othersSymptomsCount +=1 ;
                            $('[name="' + name + '"][type="checkbox"][value="Others' + othersSymptomsCount + '"]').prop('checked', true).change();
                            $('[name="OthersSymptom' + othersSymptomsCount + '"][type="text"]').val(value);
                    }
              }

            }
          } else if ($('[name="' + name + '"]').is('select')) {
            if (name == 'vacTbKind_1') {
              setVaccineTypeLoadAcction("cVac_1" ,$("#vaccine-type_1") );
            }
            if (name == 'vacTbSell_1') {
              setVaccineLoadAction($('input[name="cVac_1"]:radio'), $("#vaccine-type_1") , $("#vaccine-company_1") ,$("#vacTbIno_1") );
            }
            if (name == 'vacTbKind_2') {
              setVaccineTypeLoadAcction("cVac_2" ,$("#vaccine-type_2") );
            }
            if (name == 'vacTbSell_2') {
              setVaccineLoadAction($('input[name="cVac_2"]:radio'), $("#vaccine-type_2") , $("#vaccine-company_2") ,$("#vacTbIno_2") );
            }
            if (name == 'vacTbKind_3') {
              setVaccineTypeLoadAcction("cVac_3" ,$("#vaccine-type_3") );
            }
            if (name == 'vacTbSell_3') {
              setVaccineLoadAction($('input[name="cVac_3"]:radio'), $("#vaccine-type_3") , $("#vaccine-company_3") ,$("#vacTbIno_3") );
            }
            if (name == 'vacTbKind_4') {
              setVaccineTypeLoadAcction("cVac_4" ,$("#vaccine-type_4") );
            }
            if (name == 'vacTbSell_4') {
              setVaccineLoadAction($('input[name="cVac_4"]:radio'), $("#vaccine-type_4") , $("#vaccine-company_4") ,$("#vacTbIno_4") );
            }
            if (name == 'vacTbKind_5') {
              setVaccineTypeLoadAcction("cVac_5" ,$("#vaccine-type_5") );
            }
            if (name == 'vacTbSell_5') {
              setVaccineLoadAction($('input[name="cVac_5"]:radio'), $("#vaccine-type_5") , $("#vaccine-company_5") ,$("#vacTbIno_5") );
            }
            if (name == 'vacTbKind_6') {
              setVaccineTypeLoadAcction("cVac_6" ,$("#vaccine-type_6") );
            }
            if (name == 'vacTbSell_6') {
              setVaccineLoadAction($('input[name="cVac_6"]:radio'), $("#vaccine-type_6") , $("#vaccine-company_6") ,$("#vacTbIno_6") );
            }
            if (name == 'vacTbKind_7') {
              setVaccineTypeLoadAcction("cVac_7" ,$("#vaccine-type_7") );
            }
            if (name == 'vacTbSell_7') {
              setVaccineLoadAction($('input[name="cVac_7"]:radio'), $("#vaccine-type_7") , $("#vaccine-company_7") ,$("#vacTbIno_7") );
            }
            if (name == 'vacTbKind_8') {
              setVaccineTypeLoadAcction("cVac_8" ,$("#vaccine-type_8") );
            }
            if (name == 'vacTbSell_8') {
              setVaccineLoadAction($('input[name="cVac_8"]:radio'), $("#vaccine-type_8") , $("#vaccine-company_8") ,$("#vacTbIno_8") );
            }
            if (name == 'vacTbKind_9') {
              setVaccineTypeLoadAcction("cVac_9" ,$("#vaccine-type_9") );
            }
            if (name == 'vacTbSell_9') {
              setVaccineLoadAction($('input[name="cVac_9"]:radio'), $("#vaccine-type_9") , $("#vaccine-company_9") ,$("#vacTbIno_9") );
            }
            if (name == 'vacTbKind_10') {
              setVaccineTypeLoadAcction("cVac_10" ,$("#vaccine-type_10") );
            }
            if (name == 'vacTbSell_10') {
              setVaccineLoadAction($('input[name="cVac_10"]:radio'), $("#vaccine-type_10") , $("#vaccine-company_10") ,$("#vacTbIno_10") );
            }
            if (name == 'Patients_dateOfBirth') {
              setDayAction( $("#month-birthday") , $("#days-birthday") ,true);
            }
            if (name == 'vacTbDD_1') {
              setDayAction( $("#month-vaccine_1")  , $("#days-vaccine_1") , true );
            }
            if (name == 'vacTbDD_2') {
              setDayAction( $("#month-vaccine_2")  , $("#days-vaccine_2") , true );
            }
            if (name == 'vacTbDD_3') {
              setDayAction( $("#month-vaccine_3")  , $("#days-vaccine_3") , true );
            }
            if (name == 'vacTbDD_4') {
              setDayAction( $("#month-vaccine_4")  , $("#days-vaccine_4") , true );
            }
            if (name == 'vacTbDD_5') {
              setDayAction( $("#month-vaccine_5")  , $("#days-vaccine_5") , true );
            }
            if (name == 'vacTbDD_6') {
              setDayAction( $("#month-vaccine_6")  , $("#days-vaccine_6") , true );
            }
            if (name == 'vacTbDD_7') {
              setDayAction( $("#month-vaccine_7")  , $("#days-vaccine_7") , true );
            }
            if (name == 'vacTbDD_8') {
              setDayAction( $("#month-vaccine_8")  , $("#days-vaccine_8") , true );
            }
            if (name == 'vacTbDD_9') {
              setDayAction( $("#month-vaccine_9")  , $("#days-vaccine_9") , true );
            }
            if (name == 'vacTbDD_10') {
              setDayAction( $("#month-vaccine_10")  , $("#days-vaccine_10") , true );
            }
            if (name == 'symptom_DayOfVaccine') {
              setDayAction( $("#month-symptom")  , $("#days-symptom") ,true );
            }
            if (name == 'HospInDD') {
              setDayAction( $("#month-hospitalized") , $("#days-hospitalized"),true );
            }
            if (name == 'HospOutDD') {
              setDayAction( $("#month-discharged") , $("#days-discharged") ,true );
            }
            if (name == 'result_Day') {
              setDayAction( $("#month-result")   , $("#days-result") ,true );
            }
            if (name == 'year-adem21') {
              document.getElementById('year-adem21').disabled = false;//強制オープン
            }
            if (name == 'month-adem21') {
              document.getElementById('month-adem21').disabled = false;//強制オープン
            }
            if (name == 'days-adem21') {
              document.getElementById('days-adem21').disabled = false;//強制オープン
              setDayAction( $("#month-adem21")   , $("#days-adem21") ,true );
            }
            if (name == 'days-adem31') {
              setDayAction( $("#month-adem31")   , $("#days-adem31") ,true );
            }
            if (name == 'days-adem62') {
              setDayAction( $("#month-adem62")   , $("#days-adem62") ,true );
            }
            if (name == 'days-adem72') {
              setDayAction( $("#month-adem72")   , $("#days-adem72") ,true );
            }
            if (name == 'days-gbs11') {
              setDayAction( $("#month-gbs11")   , $("#days-gbs11") ,true );
            }
            if (name == 'days-gbs31') {
              setDayAction( $("#month-gbs31")   , $("#days-gbs31") ,true );
            }
            if (name == 'days-gbs41') {
              setDayAction( $("#month-gbs41")   , $("#days-gbs41") ,true );
            }
            if (name == 'days-gbs62') {
              setDayAction( $("#month-gbs62")   , $("#days-gbs62") ,true );
            }
            if (name == 'days-gbs72') {
              setDayAction( $("#month-gbs72")   , $("#days-gbs72") ,true );
            }
            if (name == 'days-gbs82') {
              setDayAction( $("#month-gbs82")   , $("#days-gbs82") ,true );
            }

	        // ▼▼▼
            if (name == 'days-tts1-01') {
              setDayAction( $("#month-tts1-01")   , $("#days-tts1-01") ,true );
            }
            if (name == 'days-tts1-02') {
              setDayAction( $("#month-tts1-02")   , $("#days-tts1-02") ,true );
            }
            if (name == 'days-tts1-03') {
              setDayAction( $("#month-tts1-03")   , $("#days-tts1-03") ,true );
            }
            if (name == 'days-tts1-04') {
              setDayAction( $("#month-tts1-04")   , $("#days-tts1-04") ,true );
            }
            if (name == 'days-tts1-05') {
              setDayAction( $("#month-tts1-05")   , $("#days-tts1-05") ,true );
            }
            if (name == 'days-tts1-06') {
              setDayAction( $("#month-tts1-06")   , $("#days-tts1-06") ,true );
            }
            if (name == 'days-tts1-07') {
              setDayAction( $("#month-tts1-07")   , $("#days-tts1-07") ,true );
            }
            if (name == 'days-tts1-08') {
              setDayAction( $("#month-tts1-08")   , $("#days-tts1-08") ,true );
            }
            if (name == 'days-tts1-09') {
              setDayAction( $("#month-tts1-09")   , $("#days-tts1-09") ,true );
            }
            if (name == 'days-tts1-10') {
              setDayAction( $("#month-tts1-10")   , $("#days-tts1-10") ,true );
            }
            if (name == 'days-tts1-11') {
              setDayAction( $("#month-tts1-11")   , $("#days-tts1-11") ,true );
            }
            if (name == 'days-tts1-12') {
              setDayAction( $("#month-tts1-12")   , $("#days-tts1-12") ,true );
            }
            if (name == 'days-tts1-13') {
              setDayAction( $("#month-tts1-13")   , $("#days-tts1-13") ,true );
            }
            if (name == 'days-tts1-14') {
              setDayAction( $("#month-tts1-14")   , $("#days-tts1-14") ,true );
            }
            if (name == 'days-tts1-15') {
              setDayAction( $("#month-tts1-15")   , $("#days-tts1-15") ,true );
            }
            if (name == 'days-tts1-16') {
              setDayAction( $("#month-tts1-16")   , $("#days-tts1-16") ,true );
            }
            if (name == 'days-tts1-17') {
              setDayAction( $("#month-tts1-17")   , $("#days-tts1-17") ,true );
            }
            if (name == 'days-tts1-18') {
              setDayAction( $("#month-tts1-18")   , $("#days-tts1-18") ,true );
            }
            if (name == 'days-tts1-19') {
              setDayAction( $("#month-tts1-19")   , $("#days-tts1-19") ,true );
            }
            if (name == 'days-tts1-20') {
              setDayAction( $("#month-tts1-20")   , $("#days-tts1-20") ,true );
            }
            if (name == 'days-tts1-21') {
              setDayAction( $("#month-tts1-21")   , $("#days-tts1-21") ,true );
            }
            if (name == 'days-tts1-22') {
              setDayAction( $("#month-tts1-22")   , $("#days-tts1-22") ,true );
            }
            if (name == 'days-tts1-23') {
              setDayAction( $("#month-tts1-23")   , $("#days-tts1-23") ,true );
            }
            if (name == 'days-tts1-24') {
              setDayAction( $("#month-tts1-24")   , $("#days-tts1-24") ,true );
            }
            if (name == 'days-tts1-25') {
              setDayAction( $("#month-tts1-25")   , $("#days-tts1-25") ,true );
            }
            if (name == 'days-tts1-26') {
              setDayAction( $("#month-tts1-26")   , $("#days-tts1-26") ,true );
            }
            if (name == 'days-tts1-27') {
              setDayAction( $("#month-tts1-27")   , $("#days-tts1-27") ,true );
            }
            if (name == 'days-tts1-28') {
              setDayAction( $("#month-tts1-28")   , $("#days-tts1-28") ,true );
            }
            if (name == 'days-tts1-29') {
              setDayAction( $("#month-tts1-29")   , $("#days-tts1-29") ,true );
            }
            if (name == 'days-tts1-30') {
              setDayAction( $("#month-tts1-30")   , $("#days-tts1-30") ,true );
            }
            if (name == 'days-tts1-31') {
              setDayAction( $("#month-tts1-31")   , $("#days-tts1-31") ,true );
            }
            if (name == 'days-tts1-32') {
              setDayAction( $("#month-tts1-32")   , $("#days-tts1-32") ,true );
            }
            if (name == 'days-tts1-33') {
              setDayAction( $("#month-tts1-33")   , $("#days-tts1-33") ,true );
            }
            if (name == 'days-tts1-34') {
              setDayAction( $("#month-tts1-34")   , $("#days-tts1-34") ,true );
            }
            if (name == 'days-tts1-35') {
              setDayAction( $("#month-tts1-35")   , $("#days-tts1-35") ,true );
            }
            if (name == 'days-tts1-36') {
              setDayAction( $("#month-tts1-36")   , $("#days-tts1-36") ,true );
            }
            if (name == 'days-tts1-37') {
              setDayAction( $("#month-tts1-37")   , $("#days-tts1-37") ,true );
            }
            if (name == 'days-tts2-01') {
              setDayAction( $("#month-tts2-01")   , $("#days-tts2-01") ,true );
            }
            if (name == 'days-tts2-04') {
              setDayAction( $("#month-tts2-04")   , $("#days-tts2-04") ,true );
            }
            if (name == 'days-tts2-05') {
              setDayAction( $("#month-tts2-05")   , $("#days-tts2-05") ,true );
            }
            if (name == 'days-tts2-06') {
              setDayAction( $("#month-tts2-06")   , $("#days-tts2-06") ,true );
            }
            if (name == 'days-tts2-07') {
              setDayAction( $("#month-tts2-07")   , $("#days-tts2-07") ,true );
            }
            if (name == 'days-tts3-01') {
              setDayAction( $("#month-tts3-01")   , $("#days-tts3-01") ,true );
            }
            if (name == 'days-tts3-02') {
              setDayAction( $("#month-tts3-02")   , $("#days-tts3-02") ,true );
            }
            if (name == 'days-tts3-03') {
              setDayAction( $("#month-tts3-03")   , $("#days-tts3-03") ,true );
            }
            if (name == 'days-tts3-04') {
              setDayAction( $("#month-tts3-04")   , $("#days-tts3-04") ,true );
            }
            if (name == 'days-tts3-05') {
              setDayAction( $("#month-tts3-05")   , $("#days-tts3-05") ,true );
            }
            if (name == 'days-tts3-06') {
              setDayAction( $("#month-tts3-06")   , $("#days-tts3-06") ,true );
            }
            if (name == 'days-tts3-07') {
              setDayAction( $("#month-tts3-07")   , $("#days-tts3-07") ,true );
            }
            if (name == 'days-tts4-01') {
              setDayAction( $("#month-tts4-01")   , $("#days-tts4-01") ,true );
            }
            if (name == 'days-tts4-02') {
              setDayAction( $("#month-tts4-02")   , $("#days-tts4-02") ,true );
            }
            if (name == 'days-tts5-03') {
              setDayAction( $("#month-tts5-03")   , $("#days-tts5-03") ,true );
            }
            if (name == 'days-tts5-04') {
              setDayAction( $("#month-tts5-04")   , $("#days-tts5-04") ,true );
            }
            //myo
            if (name == 'days-myo1-01') {
              setDayAction( $("#month-myo1-01")   , $("#days-myo1-01") ,true );
            }
            if (name == 'days-myo2-02') {
              setDayAction( $("#month-myo2-02")   , $("#days-myo2-02") ,true );
            }
            if (name == 'days-myo2-03') {
              setDayAction( $("#month-myo2-03")   , $("#days-myo2-03") ,true );
            }
            if (name == 'days-myo2-04') {
              setDayAction( $("#month-myo2-04")   , $("#days-myo2-04") ,true );
            }
            if (name == 'days-myo2-04') {
              setDayAction( $("#month-myo2-04")   , $("#days-myo2-04") ,true );
            }
            if (name == 'days-myo2-05') {
              setDayAction( $("#month-myo2-05")   , $("#days-myo2-05") ,true );
            }
            if (name == 'days-myo2-06') {
              setDayAction( $("#month-myo2-06")   , $("#days-myo2-06") ,true );
            }
            if (name == 'days-myo2-07') {
              setDayAction( $("#month-myo2-07")   , $("#days-myo2-07") ,true );
            }
            if (name == 'days-myo2-08') {
              setDayAction( $("#month-myo2-08")   , $("#days-myo2-08") ,true );
            }
            if (name == 'days-myo2-09') {
              setDayAction( $("#month-myo2-09")   , $("#days-myo2-09") ,true );
            }
            if (name == 'days-myo2-10') {
              setDayAction( $("#month-myo2-10")   , $("#days-myo2-10") ,true );
            }
            if (name == 'days-myo2-11') {
              setDayAction( $("#month-myo2-11")   , $("#days-myo2-11") ,true );
            }
            if (name == 'days-myo2-12') {
              setDayAction( $("#month-myo2-12")   , $("#days-myo2-12") ,true );
            }
            if (name == 'days-myo2-14') {
              setDayAction( $("#month-myo2-14")   , $("#days-myo2-14") ,true );
            }
            if (name == 'days-myo2-15') {
              setDayAction( $("#month-myo2-15")   , $("#days-myo2-15") ,true );
            }
            if (name == 'days-myo2-16') {
              setDayAction( $("#month-myo2-16")   , $("#days-myo2-16") ,true );
            }
            if (name == 'days-myo2-17') {
              setDayAction( $("#month-myo2-17")   , $("#days-myo2-17") ,true );
            }
            if (name == 'days-myo2-18') {
              setDayAction( $("#month-myo2-18")   , $("#days-myo2-18") ,true );
            }
            if(name == "days-myo3-01") {
              setDayAction($("#month-myo3-01"), $("#days-myo3-01"), true);
            }
            if(name == "days-myo3-02") {
              setDayAction($("#month-myo3-02"), $("#days-myo3-02"), true);
            }
            if(name == "days-myo3-03") {
              setDayAction($("#month-myo3-03"), $("#days-myo3-03"), true);
            }
            if(name == "days-myo3-04") {
              setDayAction($("#month-myo3-04"), $("#days-myo3-04"), true);
            }
            if(name == "days-myo3-05") {
              setDayAction($("#month-myo3-05"), $("#days-myo3-05"), true);
            }
            if(name == "days-myo3-06") {
              setDayAction($("#month-myo3-06"), $("#days-myo3-06"), true);
            }
            if(name == "days-myo3-07") {
              setDayAction($("#month-myo3-07"), $("#days-myo3-07"), true);
            }
            if(name == "days-myo3-08") {
              setDayAction($("#month-myo3-08"), $("#days-myo3-08"), true);
            }
            if(name == "days-myo3-09") {
              setDayAction($("#month-myo3-09"), $("#days-myo3-09"), true);
            }
            if(name == "days-myo4-01") {
              setDayAction($("#month-myo4-01"), $("#days-myo4-01"), true);
            }
            if(name == "days-myo4-02-1") {
              setDayAction($("#month-myo4-02-1"), $("#days-myo4-02-1"), true);
            }
            if(name == "days-myo4-02-2") {
              setDayAction($("#month-myo4-02-2"), $("#days-myo4-02-2"), true);
            }
            if(name == "days-myo4-02-3") {
              setDayAction($("#month-myo4-02-3"), $("#days-myo4-02-3"), true);
            }
            if(name == "days-myo4-02-4") {
              setDayAction($("#month-myo4-02-4"), $("#days-myo4-02-4"), true);
            }
            if(name == "days-myo4-03") {
              setDayAction($("#month-myo4-03"), $("#days-myo4-03"), true);
            }
            if(name == "days-myo4-04") {
              setDayAction($("#month-myo4-04"), $("#days-myo4-04"), true);
            }
            if(name == "days-myo5-01") {
              setDayAction($("#month-myo5-01"), $("#days-myo5-01"), true);
            }
            //per
            reInitDayPer(name);
	        // ▲▲▲

         
            $('[name="' + name + '"]').val(value);

          }

        }

        var othersSymtomsCheckboxes =  $('[name="Symptom_Vaccine"][value*="Others"][type="checkbox"]:checked')
        for (i = 0; i < othersSymtomsCheckboxes.length; i++) {
               var othersBoxIndex = parseInt($(othersSymtomsCheckboxes[i]).val().split("Others")[1]);
               if( othersBoxIndex > i + 1){
               var indexNew = i+1;
                 var valueNew = $(othersSymtomsCheckboxes[i]).siblings().val();
                 $('[name="Symptom_Vaccine"][type="checkbox"][value="Others' +  indexNew + '"]').prop('checked', true).change();
                 $('[name="OthersSymptom' + indexNew + '"][type="text"]').val(valueNew);

                 $(othersSymtomsCheckboxes[i]).prop('checked', false).change();
               }
         }

      }
    }
    var init = function() {
      var clearForm = document.forms[1];
      for (var i=0;i<clearForm.elements.length; ++i) {
        var element = clearForm.elements[i];
        clearElement(element);
      }
      var clearForm = document.forms[2];
      for (var i=0;i<clearForm.elements.length; ++i) {
        var element = clearForm.elements[i];
        clearElement(element);
      }
      var clearForm = document.forms[3];
      for (var i=0;i<clearForm.elements.length; ++i) {
        var element = clearForm.elements[i];
        clearElement(element);
      }
      var clearForm = document.forms[4];
      for (var i=0;i<clearForm.elements.length; ++i) {
        var element = clearForm.elements[i];
        clearElement(element);
      }
      var clearForm = document.forms[5];
      for (var i=0;i<clearForm.elements.length; ++i) {
        var element = clearForm.elements[i];
        clearElementIncludeHidden(element);
      }
      var event = document.getElementById("notHeavy");
      if ( event != null ) {
        event.click();
      }
      event.checked = false;
      var clearForm = document.forms[6];
      for (var i=0;i<clearForm.elements.length; ++i) {
        var element = clearForm.elements[i];
        clearElement(element);
      }
      document.getElementById('lotUk_1').checked = false;
      document.getElementById('lotNo_1').disabled = false;
      document.getElementById('lotUk_1').checked = false;
      document.getElementById('lotNo_1').disabled = false;
      // 4/16修正 No16,17ここから
      document.getElementsByName('RapporteurAttributeOther')[0].disabled = true;
      document.getElementsByName('attention_yes_description')[0].disabled = true;
      document.getElementById('Others1').disabled = true;
      document.getElementById('Others2').disabled = true;
      document.getElementById('Others3').disabled = true;
      document.getElementById('Others4').disabled = true;
      document.getElementById('Others5').disabled = true;
      document.getElementById('Others6').disabled = true;
      document.getElementById('Others7').disabled = true;
      document.getElementById('Others8').disabled = true;
      document.getElementById('Others9').disabled = true;
      document.getElementById('Others10').disabled = true;
      document.getElementsByName('othersickYes_description')[0].disabled = true;
      document.getElementsByName('resultDiseaseSequelae_description')[0].disabled = true;
      // 4/16修正 No16,17ここまで
      document.getElementById('ademInputForm').style.display = "none";
      document.getElementById('gbsInputForm').style.display = "none";
      // ▼▼▼
      document.getElementById('ttsInputForm').style.display = "none";
      // ▲▲▲
      
      disabledDataForAdem();
      disabledDataForGbs();
      // ▼▼▼
      disabledDataForTts();
      // ▲▲▲
      disabledDataForMyo();
//      document.getElementById('gbs1-4-2').disabled = false;
//      document.getElementById('gbs1-4-3').disabled = false;
//      document.getElementById('gbs1-4-4').disabled = false;
//      document.getElementById('gbs1-4-5').disabled = false;
//      document.getElementById('gbs1-4-6').disabled = false;
//      document.getElementById('gbs1-4-7').disabled = false;

      document.getElementById('occurs_term_lbl').innerHTML = "";
//メッセージは消せる
//      var delEle = document.getElementById('MedicalInstitutionName-error');
//      delEle.parentNode.removeChild(delEle);
//      self.html.removeClass('error');
      var removeCnt = count;
      for (var i=1;i<removeCnt;i++) {
        var cloneEvent = document.getElementById("Vaccine_2");
        if ( cloneEvent != null ) {
          cloneEvent.childNodes[3].childNodes[13].childNodes[3].childNodes[1].click();
        }
      }
      
      var errorClassCheck = document.getElementsByClassName('error');
      for (var i=0;i<errorClassCheck.length;) {
        var element = errorClassCheck[i];
        var check = errorClearElement(element);
        if (check) {
          i++;
        }
      }
      errorClassCheck = document.getElementsByClassName('err');
      for (var i=0;i<errorClassCheck.length;i++) {
        var element = errorClassCheck[i];
        errClearElement(element);
      }
      var mainContents = document.getElementById("main-content");
      //rapporteur
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[1].childNodes[0].style.color = "white";
      //patients
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[3].childNodes[0].style.color = "white";
      //Vaccine
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[5].childNodes[0].style.color = "white";
      //VaccinationStatus
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[7].childNodes[0].style.color = "white";
      //symptoms
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[9].childNodes[0].style.color = "white";
      //opinion
      mainContents.childNodes[1].childNodes[1].childNodes[1].childNodes[3].childNodes[11].childNodes[0].style.color = "white";
    }
    
    var clearElement = function(element) {
        switch(element.type) {
          case "text":
          case "textarea":
              element.value = "";
              return;
          case "checkbox":
          case "radio":
              element.checked = false;
              return;
          default:
        }
    }
    
    var clearElementIncludeHidden = function(element) {
        switch(element.type) {
          case "text":
          case "textarea":
          case "hidden":
              element.value = "";
              return;
          case "checkbox":
          case "radio":
              element.checked = false;
              return;
          default:
              return;
        }
    }
    var errorClearElement = function(element) {
        switch(element.localName) {
          case "label":
            element.innerHTML = "";
//            element.classList.remove('error');
            return true;
          case "input":
          case "select":
          case "textarea":
            element.classList.remove('error');
            return false;
          default:
            return true;
        }
    }
    var errClearElement = function(element) {
        switch(element.localName) {
          case "label":
            element.innerHTML = "";
            return;
          case "input":
          case "select":
          case "textarea":
            return;
          default:
            return;
        }
    }

    var manejarArchivos = function(archivo) {
      var reader = new FileReader();
      reader.onload = function(event) {
        init();
        loop(0);
        self.AppendSymptom();
        loop(1);
      };

      reader.readAsText(archivo[0]);

    }

    self.btnLoadData.on('change', function() {
      var jsonFile = this.files[0];
      if (jsonFile != null) {
        manejarArchivos(this.files);
      }else{
        alert("保存データを読み込むことが出来ませんでした");
      }
      var area = document.getElementById('loadData');
      area.parentNode.innerHTML = area.parentNode.innerHTML;
      self.btnLoadData = $('.loadData');
      self.loadData();
      alert("保存データを読み込みました");
    });
  };

  blueShipLab.prototype.saveReporterData = function() {
    var self = this;

    self.btnSaveReporterData.on('click', function() {
      var $this = $(this);
      var dataFile = '';
      var time = new Date();
      var objPcheck = document.getElementById("print_check");
      objPcheck.value ="false";

      var now = time.toString().split(' ').join('_');
      var retVal = {};
      var ReporterNm = document.getElementById('RapporteurName').value;
      if (ReporterNm == null || ReporterNm == "") {
        ReporterNm = "DrName";
      }
      var countForm = 1;
      self.validateForm.each(function() {
        var $this = $(this);
        var results = $this.serializeArray();

        var form_index = 'form_' + countForm;

        retVal[form_index] = results;
        countForm++;
        return countForm<3;
      });
      
      retVal = JSON.stringify(retVal);

      var userAgent = window.navigator.userAgent.toLowerCase();
      if (userAgent.indexOf('trident/7.0') > -1) {
//        $this.attr({
//          download: now + '.json',
//          href: "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal)
//        });
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'報告者保存_' + ReporterNm +'.json');
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
      }else if (userAgent.indexOf('msie') > -1) {
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'報告者保存_' + ReporterNm + '.json');
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
      }else if (userAgent.indexOf('edge') > -1) {
        var blobObject = new Blob([retVal]);
        window.navigator.msSaveOrOpenBlob(blobObject,'報告者保存_' + ReporterNm + '.json');
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
      }else if (userAgent.indexOf('chrome') != -1) {
        $this.attr({
          download: '報告者保存_' + ReporterNm + '.json',
          href: "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal)
        });
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
//          var obj = document.getElementById("anchor");
//          obj.href = "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal);
//          obj.innerHTML = "この部分を右クリックで保存して下さい";
      }else if (userAgent.indexOf('safari') != -1) {
        $this.attr({
          download: '報告者保存_' + ReporterNm + '.json',
          href: "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal)
        });
        alert("ダウンロードフォルダへ保存します\n保存したファイルは「データ保存」フォルダへの移動をお勧めします");
//          var obj = document.getElementById("anchor");
//          obj.href = "data:text/plain;charset=UTF-8," + encodeURIComponent(retVal);
//          obj.innerHTML = "この部分を右クリックで保存して下さい";
      }

    });
  };

  blueShipLab.prototype.loadReporterData = function() {
    var self = this;
    var loop = function() {
      var content = event.target.result;
      var contentJSON = $.parseJSON(content);
      for (var formIndex in contentJSON) {
        var formData = contentJSON[formIndex];
        if (formIndex == 'form_3') {
          break;
        }
        for (var inputIndex in formData) {
          var name = formData[inputIndex]['name'];
          var value = formData[inputIndex]['value'];

          if ($('[name="' + name + '"]').attr('type') == 'text') {

            $('[name="' + name + '"]').val(value);

          } else if ($('[name="' + name + '"]').attr('type') == 'radio') {

            $('[name="' + name + '"][type="radio"][value="' + value + '"]').prop('checked', true).trigger('change');

          } else if ($('[name="' + name + '"]').attr('type') == 'checkbox') {

            $('[name="' + name + '"][type="checkbox"][value="' + value + '"]').attr('checked', 'checked');

          } else if ($('[name="' + name + '"]').is('select')) {

            $('[name="' + name + '"]').val(value);

          }

        }

      }
    }
    var init = function() {
      var clearForm = document.forms[1];
      for (var i=0;i<clearForm.elements.length; ++i) {
        var element = clearForm.elements[i];
        clearElement(element);
      }
    }
    var clearElement = function(element) {
        switch(element.type) {
          case "text":
              element.value = "";
              return;
          case "radio":
              element.checked = false;
              return;
          default:
        }
    }
    var manejarArchivos = function(archivo) {
      var reader = new FileReader();
      reader.onload = function(event) {
        init();
        loop();
//        self.AppendSymptom();
//        loop();
      };

      reader.readAsText(archivo[0]);

    }

    self.btnLoadReporterData.on('change', function() {
      var jsonFile = this.files[0];
      if (jsonFile != null) {
        manejarArchivos(this.files);
      }else{
        alert("保存データを読み込むことが出来ませんでした");
      }
      
      var area = document.getElementById('loadReporterData');
      area.parentNode.innerHTML = area.parentNode.innerHTML;
      self.btnLoadReporterData = $('.loadReporterData');
      self.loadReporterData();
      alert("保存データを読み込みました");
    });
  };
  
  blueShipLab.prototype.lotNoClearError = function() {
    var self =this;
    self.checkedLotUnknown.on('change',function(ele) {
      var checkEle = ele.target;
      var lotNo = 'lotNo_' + checkEle.value.replace("lotUk_","")
      var element = document.getElementById(lotNo + '-error');
      if ( element != null ) {
        self.errorClearElement(element);
        element.style.display = "none";
      }
      element = document.getElementById(lotNo);
      self.errorClearElement(element);
    });
  };

  blueShipLab.prototype.symptomClearError = function() {
    var self =this;
    self.checkedSymptom.on('change',function(ele) {
      var checkEle = ele.target;
      var element = document.getElementById(checkEle.value + '-error');
      if ( element != null ) {
        self.errorClearElement(element);
        element.style.display = "none";
      }
      element = document.getElementById(checkEle.value);
      self.errorClearElement(element);
    });
  };
  
  blueShipLab.prototype.symptomStageClearError = function() {
    //重くない選択時、症状の内容にあるエラーメッセージをクリアする
    var self = this;
    var element = document.getElementById('stageDetails-error');
    if ( element != null ) {
      self.errorClearElement(element);
      element.style.display = "none";
    }
    element = document.getElementById('symptom_hopitalName-error');
    if ( element != null ) {
      self.errorClearElement(element);
      element.style.display = "none";
    }
    element = document.getElementById('symptom_doctorName-error');
    if ( element != null ) {
      self.errorClearElement(element);
      element.style.display = "none";
    }
    element = document.getElementsByName('symptom_hopitalName');
    self.errorClearElement(element[0]);
    element = document.getElementsByName('symptom_doctorName');
        self.errorClearElement(element[0]);
        element = document.getElementById('year-hospitalized');
        self.errorClearElement(element);
        element = document.getElementById('year-hospitalized-error');
        if ( element != null ) {
          self.errorClearElement(element);
          element.style.display = "none";
        }
        element = document.getElementById('month-hospitalized');
        self.errorClearElement(element);
        element = document.getElementById('month-hospitalized-error');
        if ( element != null ) {
          self.errorClearElement(element);
          element.style.display = "none";
        }
        element = document.getElementById('days-hospitalized');
        self.errorClearElement(element);
        element = document.getElementById('days-hospitalized-error');
        if ( element != null ) {
          self.errorClearElement(element);
          element.style.display = "none";
        }
        element = document.getElementById('year-discharged');
        self.errorClearElement(element);
        element = document.getElementById('year-discharged-error');
        if ( element != null ) {
          self.errorClearElement(element);
          element.style.display = "none";
        }
        element = document.getElementById('month-discharged');
        self.errorClearElement(element);
        element = document.getElementById('month-discharged-error');
        if ( element != null ) {
          self.errorClearElement(element);
          element.style.display = "none";
        }
        element = document.getElementById('days-discharged');
        self.errorClearElement(element);
        element = document.getElementById('days-discharged-error');
        if ( element != null ) {
          self.errorClearElement(element);
          element.style.display = "none";
        }
        element = document.getElementById('discharged_err');
        self.errorClearElement(element);
        element.style.display = "none";
        element = document.getElementById('discharged_hospi_err');
        self.errorClearElement(element);
        element.style.display = "none";
        element = document.getElementById('discharged_occur_err');
        self.errorClearElement(element);
        element.style.display = "none";
        // 4/16修正No10
        element = document.getElementById('hospitalized_err');
        self.errorClearElement(element);
        element.style.display = "none";

  }
  blueShipLab.prototype.outcomeClearError = function() {
    //重くない選択時、症状の内容にあるエラーメッセージをクリアする
    var self = this;
    var element = document.getElementById('resultDiseaseSequelae_description-error');
    if ( element != null ) {
      self.errorClearElement(element);
      element.style.display = "none";
    }
    element = document.getElementsByName('resultDiseaseSequelae_description');
    self.errorClearElement(element[0]);
  };
  blueShipLab.prototype.errorClearElement = function(element) {
    switch(element.localName) {
      case "label":
        element.innerHTML = "";
        element.classList.remove('error');
        return false;
      case "input":
      case "select":
      case "textarea":
        element.classList.remove('error');
        return false;
      default:
        return true;
    }
  };
  
  blueShipLab.prototype.onPosition = function() {
    var self =this;
    self.selectedPosition.on('change',function() {
      var element = document.getElementById('RapporteurAttributeOther-error');
      if ( element != null ) {
        self.errorClearElement(element);
        element.style.display = "none";
      }
      element = document.getElementsByName('RapporteurAttributeOther');
      self.errorClearElement(element[0]);
    });
  };

  blueShipLab.prototype.onNotHeavyClearError = function() {
    var self = this;
    self.notHeavyClearError.on('change',function() {
        self.symptomStageClearError();
    });
  };
    
  blueShipLab.prototype.onHospitalized = function() {
    var self =this;
    self.checkedHospitalized.on('change',function() {
      self.symptomStageClearError();
    });
  };
  
  blueShipLab.prototype.onOutcome = function() {
    var self =this;
    self.selectedOutcome.on('change',function() {
      self.outcomeClearError();
    });
  };

  blueShipLab.prototype.onOtherSick = function() {
    var self =this;
    self.selectedOtherSick.on('change',function() {
      var element = document.getElementById('othersickYes_description-error');
      if ( element != null ) {
        self.errorClearElement(element);
        element.style.display = "none";
      }
      element = document.getElementsByName('othersickYes_description');
      self.errorClearElement(element[0]);
    });
  };

  blueShipLab.prototype.onAttention = function() {
    var self =this;
    self.selectedAttention.on('change',function() {
      var element = document.getElementById('attention_yes_description-error');
      if ( element != null ) {
        self.errorClearElement(element);
        element.style.display = "none";
      }
      element = document.getElementsByName('attention_yes_description');
      self.errorClearElement(element[0]);
    });
  };
  
  blueShipLab.prototype.onChangeBirthDay = function() {
    var self = this;
    self.checkBirthdayFields.on('change', function() {
      self.checkVaccinationAge();
      self.insertAgeVaccination();
    });

    self.document.on('change', '.type-of-birthday', function() {
      self.insertAgeVaccination();
    });
  };

  blueShipLab.prototype.onChangeVaccinationYear = function() {
    var self = this;
    self.onYearClearVaccination.on('change',function(ele) {
      var element = ele.target.id;
      var monthId = element.replace("year","month");
      setMonth($('#' + monthId), true);
      var dayId = element.replace("year","days");
      setDayAction($('#' + monthId), $('#' + dayId), true);
      var hourId = element.replace("year","hour");
      setHour($('#' + hourId), true);
      var minuteId = element.replace("year","minute");
      setMinute($('#' + minuteId), true);
    });
  };

  blueShipLab.prototype.onChangeVaccinationMonth = function() {
    var self = this;
    self.onMonthClearVaccination.on('change',function(ele) {
      var element = ele.target.id;
      var hourId = element.replace("month","hour");
      setHour($('#' + hourId), true);
      var minuteId = element.replace("month","minute");
      setMinute($('#' + minuteId), true);
    });
  };

  blueShipLab.prototype.onChangeVaccinationDay = function() {
    var self = this;
    self.onDayClearVaccination.on('change',function(ele) {
      var element = ele.target.id;
      var hourId = element.replace("days","hour");
      setHour($('#' + hourId), true);
      var minuteId = element.replace("days","minute");
      setMinute($('#' + minuteId), true);
    });
  };

  blueShipLab.prototype.onChangeVaccinationHour = function() {
    var self = this;
    self.onHourClearVaccination.on('change',function(ele) {
      var element = ele.target.id;
      var minuteId = element.replace("hour","minute");
      setMinute($('#' + minuteId), true);
    });
  };

  blueShipLab.prototype.ConvertAge = function(startJapaneseYearNumberElement, endJapaneseYearNumberElement, anchor) {
    var self = this;
    var Default = true;

    $(anchor).each(function() {
      var checkBirthDay = $(this).val().length;

      if (checkBirthDay == 0) {
        Default = false;
      }
    });

    if (Default) {

      var convertYearBirthday = Number($(startJapaneseYearNumberElement).val());
      var convertYearDayInjection = Number($(endJapaneseYearNumberElement).val());

      var results = {
        startYear: convertYearBirthday,
        endYear: convertYearDayInjection
      }

      return results;

    } else {
      return false;
    }

  };

  blueShipLab.prototype.getLastVaccineDay = function(){

      var latesttime = new Date(1916, 0 , 1 );
      for( var i = 1 ; i <= count ; i++ ){
         var year = $('#year-vaccine_'+i).val();
         var month = $('#month-vaccine_'+i).val();
         var day = $('#days-vaccine_'+i).val();
         var hour = $('#hour-vaccine_'+i).val();
         var minute = $('#minute-vaccine_'+i).val();
         if (hour == "unknown") {
           hour = 0
         }
         if (minute == "unknown") {
           minute = 0
         }
         var time = new Date(year, month - 1, day,hour,minute);
         if( i==1 ) {
             latesttime = time;
         }else if (isNaN(latesttime)) {
             latesttime = time;
         }else if( time.getTime() > latesttime.getTime() ){
             latesttime = time;
         }
      }

      return latesttime;
  }

  blueShipLab.prototype.getLastVaccineDayExcludeTime = function(){

      var latesttime = new Date(1916, 0 , 1 );
      for( var i = 1 ; i <= count ; i++ ){
         var year = $('#year-vaccine_'+i).val();
         var month = $('#month-vaccine_'+i).val();
         var day = $('#days-vaccine_'+i).val();
         var time = new Date(year, month - 1, day,0,0);
         if( i==1 ) {
             latesttime = time;
         }else if (isNaN(latesttime)) {
             latesttime = time;
         }else if( time.getTime() > latesttime.getTime() ){
             latesttime = time;
         }
      }

      return latesttime;
  }
  
  blueShipLab.prototype.checkVaccineTimeHour = function(){

      var latesttime = new Date(1916, 0 , 1 );
      var checkUnknown = false;
      for( var i = 1 ; i <= count ; i++ ){
         var year = $('#year-vaccine_'+i).val();
         var month = $('#month-vaccine_'+i).val();
         var day = $('#days-vaccine_'+i).val();
         var hour = $('#hour-vaccine_'+i).val();
         var minute = $('#minute-vaccine_'+i).val();
         var p_checkUnknown = false;
         if (hour == "unknown") {
           hour = 0;
           p_checkUnknown = true;
         }
         if (minute == "unknown") {
           minute = 0;
         }
         var time = new Date(year, month - 1, day,hour,minute);
         if( i==1 ) {
             latesttime = time;
             checkUnknown = p_checkUnknown;
         }else if (isNaN(latesttime)) {
             latesttime = time;
             checkUnknown = p_checkUnknown;
         }else if( time.getTime() > latesttime.getTime() ){
             latesttime = time;
             checkUnknown = p_checkUnknown;
         }
      }

      return checkUnknown;
  }
  
  blueShipLab.prototype.checkVaccineTimeMinute = function(){

      var latesttime = new Date(1916, 0 , 1 );
      var checkUnknown = false;
      for( var i = 1 ; i <= count ; i++ ){
         var year = $('#year-vaccine_'+i).val();
         var month = $('#month-vaccine_'+i).val();
         var day = $('#days-vaccine_'+i).val();
         var hour = $('#hour-vaccine_'+i).val();
         var minute = $('#minute-vaccine_'+i).val();
         var p_checkUnknown = false;
         if (hour == "unknown") {
           hour = 0;
         }
         if (minute == "unknown") {
           minute = 0;
           p_checkUnknown = true;
         }
         var time = new Date(year, month - 1, day,hour,minute);
         if( i==1 ) {
             latesttime = time;
             checkUnknown = p_checkUnknown;
         }else if (isNaN(latesttime)) {
             latesttime = time;
             checkUnknown = p_checkUnknown;
         }else if( time.getTime() > latesttime.getTime() ){
             latesttime = time;
             checkUnknown = p_checkUnknown;
         }
      }

      return checkUnknown;
  }

  blueShipLab.prototype.getVaccineHour = function(){

      var latesttime = new Date(1916, 0 , 1 );
      var reHour = 0;
      for( var i = 1 ; i <= count ; i++ ){
         var year = $('#year-vaccine_'+i).val();
         var month = $('#month-vaccine_'+i).val();
         var day = $('#days-vaccine_'+i).val();
         var hour = $('#hour-vaccine_'+i).val();
         var minute = $('#minute-vaccine_'+i).val();
         var p_checkUnknown = false;
         if (hour == "unknown") {
           hour = 0;
         }
         if (minute == "unknown") {
           minute = 0;
         }
         var time = new Date(year, month - 1, day,hour,minute);
         if( i==1 ) {
             latesttime = time;
             reHour = hour;
         }else if (isNaN(latesttime)) {
             latesttime = time;
             reHour = hour;
         }else if( time.getTime() > latesttime.getTime() ){
             latesttime = time;
             reHour = hour;
         }
      }
      return reHour;
  }

  blueShipLab.prototype.getVaccineMinute = function(){

      var latesttime = new Date(1916, 0 , 1 );
      var reMinute = 0;
      for( var i = 1 ; i <= count ; i++ ){
         var year = $('#year-vaccine_'+i).val();
         var month = $('#month-vaccine_'+i).val();
         var day = $('#days-vaccine_'+i).val();
         var hour = $('#hour-vaccine_'+i).val();
         var minute = $('#minute-vaccine_'+i).val();
         var p_checkUnknown = false;
         if (hour == "unknown") {
           hour = 0;
         }
         if (minute == "unknown") {
           minute = 0;
         }
         var time = new Date(year, month - 1, day,hour,minute);
         if( i==1 ) {
             latesttime = time;
             reMinute = minute;
         }else if (isNaN(latesttime)) {
             latesttime = time;
             reMinute = minute;
         }else if( time.getTime() > latesttime.getTime() ){
             latesttime = time;
             reMinute = minute;
         }
      }
      return reMinute;
  }

  blueShipLab.prototype.getLastVaccineDayFromBirth = function(){
    var self = this;
    var Default = true;

    $('.check-birthday').each(function() {
      var checkBirthDay = $(this).val().length;

      if (checkBirthDay == 0) {
        Default = false;
      }
    });

    if (!Default) {
      return false;
    }

    var latesttime = self.getLastVaccineDay();

    var birthYear  = $('.wrap-time-birthday .Year-follow-JapaneseCalendar').val();
    var birthMonth = $('.wrap-time-birthday .Patients_monthOfBirth').val();
    var birthDay   = $('.wrap-time-birthday .Patients_dateOfBirth').val();
    var birthtime = new Date(birthYear, birthMonth-1, birthDay );

    var retValDays = dayDiff(birthtime, latesttime);

    var DaysToWeeks = retValDays / 7;
    var retValWeeks = Number(parseFloat(DaysToWeeks).toFixed(0));

    var retValMonths = monthDiff(birthtime, latesttime);
    var surplusMonths = retValMonths % 12;

    var retValYears = yearDiff(birthtime, latesttime);

    var insertAgeVaccination = {
      day: retValDays,
      week: retValWeeks,
      month: retValMonths,
      surplus: surplusMonths,
      year: retValYears
    }

    return insertAgeVaccination;
  }

  blueShipLab.prototype.checkVaccinationAge = function() {
    var self = this;

    var yearResults = self.ConvertAge('.wrap-time-birthday .Year-follow-JapaneseCalendar','.first-table .wrap-date-vaccinations .Year-follow-JapaneseCalendar', '.check-birthday');

    var getStartMonth = $('.wrap-time-birthday .Patients_monthOfBirth').val();
    var getStartDate = $('.wrap-time-birthday .Patients_dateOfBirth').val();

    var getEndMonth = $('.first-table .Month-follow-JapaneseCalendar').val();
    var getEndDate = $('.first-table .Date-follow-JapaneseCalendar').val();

    var Yearstart = new Date(yearResults.startYear, getStartMonth - 1, getStartDate);
    var Yearend = new Date(yearResults.endYear, getEndMonth - 1, getEndDate);

    var retValDays = dayDiff(Yearstart, Yearend);

    var DaysToWeeks = retValDays / 7;
    var retValWeeks = Number(parseFloat(DaysToWeeks).toFixed(0));

    var retValMonths = monthDiff(Yearstart, Yearend);
    var surplusMonths = retValMonths % 12;

    var retValYears = yearDiff(Yearstart, Yearend);

    var insertAgeVaccination = {
      day: retValDays,
      week: retValWeeks,
      month: retValMonths,
      surplus: surplusMonths,
      year: retValYears
    }

    return insertAgeVaccination;

  };

  blueShipLab.prototype.insertAgeVaccination = function() {
    var self = this;
    var typeOfBirthday = $('.type-of-birthday:checked').val();
    var checkVaccinationAge = self.getLastVaccineDayFromBirth();
    var changeValueBirthday = $('[name="vaccinationAge"]');

    if (typeOfBirthday == "week") {
      var insertAgeVaccination = checkVaccinationAge.week;
    } else if (typeOfBirthday == "year") {
      var insertAgeVaccination = checkVaccinationAge.year;
      var insertSurplusMonths = checkVaccinationAge.surplus;
    }

    var inputCheckAge = $('.check-age');
    var inputSurplusMonths = $('.insert-month');

    inputCheckAge.val(insertAgeVaccination);
    inputSurplusMonths.val(insertSurplusMonths);

  };

  blueShipLab.prototype.onChangeDateOccurs = function() {
    var self = this;
    self.checkDateOccursFields.on('change', function() {
      self.getOccursDateFromLast();
    });
  };

  blueShipLab.prototype.getOccursDateFromLast = function() {
      var self = this;
      var Default = true;

      $('.check-DateOccurs').each(function() {
        
        
        if ( $(this).val() == null ) {
          var checkBirthDay = $(this).id;
        }else{
          var checkBirthDay = $(this).val().length;
        }
        if (checkBirthDay == 0) {
          Default = false;
        }
      });

      if (!Default) {
        //初期化を行う ここで発生日時の初期化を行う
        // 4/16修正 No9
        var results = '';
        var days = '';
        var hours = '';
        $('.date_occurs_days').val(days);
        $('.date_occurs_times').val(hours);
        document.getElementById("occurs_term_lbl").innerText = results;
        return false;
      }

      var obj = document.getElementById("term_error");
      obj.innerText = "";
      obj.style.display = "none";

      var DateTimeStart = self.getLastVaccineDay();
      var DateTimeStartExTime = self.getLastVaccineDayExcludeTime();
      var timeUnknownHour = self.checkVaccineTimeHour();
      var timeUnknownMinute = self.checkVaccineTimeMinute();
      var startHour = self.getVaccineHour();
      var startMinute = self.getVaccineMinute();
      
      var endYear  = $('.wrap-date-occurs .Year-follow-JapaneseCalendar').val();
      var endMonth = $('.wrap-date-occurs .Month-follow-JapaneseCalendar').val();
      var endDate  = $('.wrap-date-occurs .Date-follow-JapaneseCalendar').val();
      var endHour  = $('.wrap-date-occurs .Hour-follow-JapaneseCalendar').val();
      var endMinute = $('.wrap-date-occurs .Minute-follow-JapaneseCalendar').val();
      if (timeUnknownMinute) {
        endMinute = 0;
      }
      if (endMinute == "unknown") {
        endMinute = startMinute;
        timeUnknownMinute = true;
      }
      if (timeUnknownHour) {
        endHour = 0;
        endMinute = startMinute;
      }
      if (endHour == "unknown") {
        endHour = startHour;
        endMinute = startMinute;
        timeUnknownHour = true;
      }
      var DateTimeEnd = new Date(endYear, endMonth-1 , endDate, endHour, endMinute);
      var DateTimeEndExTime = new Date(endYear, endMonth-1 , endDate, 0, 0);

      var Milisecond = DateTimeEnd - DateTimeStart;
      var MilisecondExTime = DateTimeEndExTime - DateTimeStartExTime;
      var Second = Math.floor(Milisecond / 1000);

      var Days = Math.floor(Second / 86400);

      var balances = Second % 86400;
      var Hours = Math.floor(balances / 3600);

      balances = balances % 3600;
      var Minutes = Math.floor(balances / 60);
      
      var rtnFlg = false;
      if ( isNaN( Milisecond ) ) {
        var results ='計算不能';
        var days = '不明';
        var hours = '';
        rtnFlg = true;
      }else if ( MilisecondExTime < 0 ){
        var obj = document.getElementById("term_error");
        obj.innerText = "発生日時が接種日時より過去の日付になっています";
        obj.style.display = "";
        var results ='期間が負の日数です';
        var days = '不明';
        var hours = '';
        rtnFlg = false;
      }else if (timeUnknownHour) {
        var results = Days + '日 ';
        var days = Days + '日 ';
        var hours = '不明';
        rtnFlg = true;
      }else if ( Days < 0 || Hours < 0 ){
        var obj = document.getElementById("term_error");
        obj.innerText = "発生日時が接種日時より過去の日付になっています";
        obj.style.display = "";
        var results ='期間が負の日数です';
        var days = '不明';
        var hours = '';
        rtnFlg = false;
      }else if (timeUnknownMinute) {
        var results = Days + '日 ' + Hours + '時間 ';
        var days = Days + '日 ';
        var hours = Hours + '時間 ';
        rtnFlg = true;
      }else if ( Milisecond < 0 ){
        var obj = document.getElementById("term_error");
        obj.innerText = "発生日時が接種日時より過去の日付になっています";
        obj.style.display = "";
        var results ='期間が負の日数です';
        var days = '不明';
        var hours = '';
        rtnFlg = false;
      }else{
        var results = Days + '日 ' + Hours + '時間 ' + Minutes + '分';
        var days = Days + '日 ';
        var hours = Hours + '時間 ' + Minutes + '分';
        rtnFlg = true;
      }
      $('.date_occurs_days').val(days);
      $('.date_occurs_times').val(hours);
      document.getElementById("occurs_term_lbl").innerText = results;
      return rtnFlg;

  }

  blueShipLab.prototype.insertDateOccurs = function() {
    var self = this;
    var yearResults = self.ConvertAge('.first-table .wrap-date-vaccinations .Year-follow-JapaneseCalendar', '.wrap-date-occurs .Year-follow-JapaneseCalendar', '.check-DateOccurs');

    var startYear = yearResults.startYear;
    var startMonth = $('.first-table .wrap-date-vaccinations .Month-follow-JapaneseCalendar').val();
    var startDate = $('.first-table .wrap-date-vaccinations .Date-follow-JapaneseCalendar').val();
    var startHour = $('.first-table .wrap-date-vaccinations .Hour-follow-JapaneseCalendar').val();
    var startMinute = $('.first-table .wrap-date-vaccinations .Minute-follow-JapaneseCalendar').val();

    var endYear = yearResults.endYear;
    var endMonth = $('.wrap-date-occurs .Month-follow-JapaneseCalendar').val();
    var endDate = $('.wrap-date-occurs .Date-follow-JapaneseCalendar').val();
    var endHour = $('.wrap-date-occurs .Hour-follow-JapaneseCalendar').val();
    var endMinute = $('.wrap-date-occurs .Minute-follow-JapaneseCalendar').val();
    if (endMinute == "unknown") {
      endMinute = 0
    }
    if (endHour == "unknown") {
      endHour = 0
    }
    if (startMinute == "unknown") {
      startMinute = 0
    }
    if (startHour == "unknown") {
      startHour = 0
    }

    var obj = document.getElementById("term_error");
    obj.innerText = "";
    obj.style.display = "none";

    var DateTimeStart = new Date(startYear, startMonth, startDate, startHour, startMinute);
    var DateTimeEnd = new Date(endYear, endMonth, endDate, endHour, endMinute);

    var Milisecond = DateTimeEnd - DateTimeStart;

    var Second = Math.floor(Milisecond / 1000);

    var Days = Math.floor(Second / 86400);

    var balances = Second % 86400;
    var Hours = Math.floor(balances / 3600);

    balances = balances % 3600;
    var Minutes = Math.floor(balances / 60);
    if ( isNaN( Milisecond ) ) {
      var results ='計算不能';
    }else if ( Milisecond < 0 ){
      var obj = document.getElementById("term_error");
      obj.innerText = "発生日時が接種日時よりも過去になっています";
      obj.style.display = "";
      var results ='期間が負の日数です';
    }else{
      var results = Days + '日 ' + Hours + '時間 ' + Minutes + '分';
      var days = Days + '日';
      var hours = Hours + '時間' + Minutes + '分';
    }
    $('.date_occurs_days').val(days);
    $('.date_occurs_times').val(hours);
    document.getElementById("occurs_term_lbl").innerText = results;

  };

  blueShipLab.prototype.bindRadioChange = function() {
    var self = this;
    self.radio.change(function() {
      var $this = $(this);
      var getName = $(this).data('group');
      var getData = $(this).data('check');
      var dataRequired = $('[data-required="' + getData + '"]');
      var dataRequiredNotDelVal = $('[data-required-notDelVal="' + getData + '"]');

      if ($this.attr('type') == 'radio') {
          if ($this.is(':checked') && $this.hasClass('toggle-attr')) {
            var getData = $(this).data('check');
            $('#data-hidden-'+getData).show();
            $('[data-required="' + getData + '"]').attr('disabled', false);
            $('[data-required-notDelVal="' + getData + '"]').attr('disabled', false);
          } else {
            $('#data-hidden-'+getName).hide();
            $('[data-required="' + getName + '"]').attr('disabled', true);
            $('[data-required="' + getName + '"]').val('');
            $('[data-required-notDelVal="' + getName + '"]').attr('disabled', true);
            $('.data-check-clear-'+getName).prop({'checked':false});
            $('.data-clear-'+getName).val('');
            $('.data-disabled-'+getName).attr('disabled','disabled');
          }
          if ($this.is(':checked') && $this.hasClass('toggle-attr-adem')) {
            var getData = $(this).data('check');
            var getRemoveData = $(this).data('remove');
            $('#data-hidden-'+getData).show();
            $('[data-required="' + getData + '"]').attr('disabled', false);
            $('[data-required-notDelVal="' + getData + '"]').attr('disabled', false);
            
            $('.data-check-clear-'+getRemoveData).prop({'checked':false});
            $('.data-clear-'+getRemoveData).val('');
            $('.data-disabled-'+getRemoveData).attr('disabled','disabled');
          }
        }

      if ($this.attr('type') == 'checkbox') {
        if ($this.is(':checked') && $this.hasClass('toggle-attr')) {
          if (dataRequired.attr('disabled') == 'disabled') {
            dataRequired.attr('disabled', false);
          } else if (dataRequired.attr('disabled') == false || dataRequired.attr('disabled') == undefined) {
            dataRequired.attr('disabled', 'disabled');
            dataRequired.val('');
          }
        } else if ($this.is(':unchecked') && $this.hasClass('toggle-attr')) {
          if (dataRequired.attr('disabled') == 'disabled') {
            dataRequired.attr('disabled', false);
          } else if (dataRequired.attr('disabled') == false || dataRequired.attr('disabled') == undefined) {
            dataRequired.attr('disabled', 'disabled');
            dataRequired.val('');
          }
        } else if ($this.is(':checked') && $this.hasClass('toggle-attr-adem')) {
          if (dataRequiredNotDelVal.attr('disabled') == 'disabled') {
            dataRequiredNotDelVal.attr('disabled', false);
          } else if (dataRequiredNotDelVal.attr('disabled') == false || dataRequiredNotDelVal.attr('disabled') == undefined) {
            dataRequiredNotDelVal.attr('disabled', 'disabled');
          }
        } else if ($this.is(':unchecked') && $this.hasClass('toggle-attr-adem')) {
          if (dataRequiredNotDelVal.attr('disabled') == 'disabled') {
            dataRequiredNotDelVal.attr('disabled', false);
            $('.data-check-clear-'+getName).prop({'checked':false});
            $('.data-disabled-'+getName).attr('disabled','disabled');
          } else if (dataRequiredNotDelVal.attr('disabled') == false || dataRequiredNotDelVal.attr('disabled') == undefined) {
            dataRequiredNotDelVal.attr('disabled', 'disabled');
            $('.data-check-clear-'+getName).prop({'checked':false});
            $('.data-disabled-'+getName).attr('disabled','disabled');
            $('.data-clear-'+getName).val('');
            $('.data-disabled-'+getName).attr('disabled','disabled');
          }
        }
      }
    });
  };

  blueShipLab.prototype.removeAppendError = function() {
    $('.append-table-error').remove();
  };

  blueShipLab.prototype.bindCloneTable = function() {

    var self = this;
    var getDataClone = self.firstTable.clone(true, true).get(0);

    $(document).on('click', '.btn-clone', function(e) {
      e.preventDefault();
      self.removeAppendError();
      if ($('.clone').length >= 10) {
        $('.append-table').append('<span class="append-table-error">ワクチン登録は10個までです</span>');
        return false;
      }

      var cloned = $(getDataClone).clone(true, true).get(0);
      count++;

      cloned.id = "Vaccine_" + count;

      $(cloned).find("*").each(function(index, element) {
          if (element.id) {
             var matches = element.id.match(/(.+)_\d+/);
             if (matches && matches.length >= 2)
                element.id = matches[1] + "_" + count;
          }
      });
      $(cloned).find("*").each(function(index, element) {
          if (element.name) {
            var matches = element.name.match(/(.+)_\d+/);
              if (matches && matches.length >= 2)
                element.name = matches[1] + "_" + count;
          }
      });
      $(cloned).find("*").each(function(index, element) {
          if ($(element).attr('for')) {
            var matches = $(element).attr('for').match(/(.+)_\d+/);
            if (matches && matches.length >= 2)
                $(element).attr('for', matches[1] + "_" + count);
          }
      });
      $(cloned).find("*").each(function(index, element) {
          if ($(element).attr('value')) {
              var matches = $(element).attr('value').match(/(.+)_\d+/);
              if (matches && matches.length >= 2)
               $(element).attr('value', matches[1] + "_" + count);
          }
      });
      $(cloned).find("*").each(function(index, element) {
          if ($(element).attr('data-required')) {
            var matches = $(element).attr('data-required').match(/(.+)_\d+/);
            if (matches && matches.length >= 2)
              $(element).attr('data-required', matches[1] + "_" + count);
          }
      });
      $(cloned).find("*").each(function(index, element) {
          if ($(element).attr('data-group')) {
            var matches = $(element).attr('data-group').match(/(.+)_\d+/);
            if (matches && matches.length >= 2)
              $(element).attr('data-group', matches[1] + "_" + count);
          }
      });
      $(cloned).find("*").each(function(index, element) {
          if ($(element).attr('data-check')) {
            var matches = $(element).attr('data-check').match(/(.+)_\d+/);
            if (matches && matches.length >= 2)
              $(element).attr('data-check', matches[1] + "_" + count);
          }
      });

      $(cloned).find('.table-number').html(count);
      $(cloned).removeClass('first-table').appendTo($(".append-table"));

      setYear( $('#year-vaccine_' + count ),1989,y,true);
      setMonth( $('#month-vaccine_' + count), true );
      setDayAction( $('#month-vaccine_' + count)  , $('#days-vaccine_' + count ) , true );
      setHour( $('#hour-vaccine_' + count), true );
      setMinute( $('#minute-vaccine_' + count), true );
      setVaccineTypeAcction($('input[name="cVac_' + count +'"]:radio'),$('#vaccine-type_' + count ), $('#vaccine-company_' + count ) ,$('#vacTbIno_' + count ) , count );
      setVaccineAction($('input[name="cVac_' + count +'"]:radio'),$('#vaccine-type_' + count) , $('#vaccine-company_' + count ) ,$('#vacTbIno_' + count ) , count );
      $("#help-exp-undefine_" + count).darkTooltip({
          gravity:'west',
          theme:'dark',
      });
      $("#help-exp-vaccine_" + count ).darkTooltip({
          gravity:'west',
          theme:'dark',
      });

    });
  };

  blueShipLab.prototype.removeClonedTable = function() {
    var self = this;
    self.document.on('click', '.btn-remove-this-table', function(e) {
      e.preventDefault();
      self.removeAppendError();
      $(this).closest('.clone').remove();
      count--;
      for(var i=2;i<count+1;i++){
        if ( document.getElementById("vaccine-type_" + i) ) {
          var checkCnt = count;
        }else{
          //Idその他を上に詰める
          var chgId = i + 1;
          var chgIdName = document.getElementById("Vaccine_" + chgId);
          chgIdName.id = "Vaccine_" + i;
//          var node_0 = chgIdName.childNodes[0];
          chgIdName.childNodes[1].childNodes[1].innerHTML = i;
          chgIdName.childNodes[3].childNodes[13].childNodes[3].childNodes[1].childNodes[1].innerHTML = i;
          //ワクチンの種類
          chgIdName = document.getElementById("vaccine-type_" + chgId);
          chgIdName.id = "vaccine-type_" + i;
          chgIdName.name = "vacTbKind_"  + i;
          //接種種別
          chgIdName = document.getElementById("periodic_" + chgId);
          chgIdName.id = "periodic_" + i;
          chgIdName.name = "cVac_" + i;
          chgIdName = document.getElementById("spontaneous_" + chgId);
          chgIdName.id = "spontaneous_" + i;
          chgIdName.name = "cVac_" + i;
          chgIdName = document.getElementById("l_periodic_" + chgId);
          chgIdName.id = "l_periodic_" + i;
          chgIdName = document.getElementById("l_spontaneous_" + chgId);
          chgIdName.id = "l_spontaneous_" + i;
          //ロット番号
          chgIdName = document.getElementById("lotNo_" + chgId);
          chgIdName.id = "lotNo_" + i;
          chgIdName.name = "lotNo_" + i;
          $('#' + chgIdName.id).attr('data-required',"lotNo_" + i);
//          chgIdName.data-required = "lotNo_" + i;
          chgIdName = document.getElementById("lotUk_" + chgId);
          chgIdName.id = "lotUk_" + i;
          chgIdName.name = "lotUk_" + i;
          chgIdName.value = "lotUk_" + i;
          $('#' + chgIdName.id).attr('data-group',"lotNo_" + i);
          $('#' + chgIdName.id).attr('data-check',"lotNo_" + i);
          chgIdName = document.getElementById("help-exp-undefine_" + chgId);
          chgIdName.id = "help-exp-undefine_" + i;
          chgIdName = document.getElementById("l_lotUk_" + chgId);
          chgIdName.id = "l_lotUk_" + i;
          //製造販売業者
          chgIdName = document.getElementById("vaccine-company_" + chgId);
          chgIdName.id = "vaccine-company_" + i;
          chgIdName.name = "vacTbSell_" + i;
          //接種日時
          chgIdName = document.getElementById("year-vaccine_" + chgId);
          chgIdName.id = "year-vaccine_" + i;
          chgIdName.name = "vacTbYY_" + i;
          chgIdName = document.getElementById("month-vaccine_" + chgId);
          chgIdName.id = "month-vaccine_" + i;
          chgIdName.name = "vacTbMth_" + i;
          chgIdName = document.getElementById("days-vaccine_" + chgId);
          chgIdName.id = "days-vaccine_" + i;
          chgIdName.name = "vacTbDD_" + i;
          chgIdName = document.getElementById("hour-vaccine_" + chgId);
          chgIdName.id = "hour-vaccine_" + i;
          chgIdName.name = "vacTbHH_" + i;
          chgIdName = document.getElementById("minute-vaccine_" + chgId);
          chgIdName.id = "minute-vaccine_" + i;
          chgIdName.name = "vacTbMin_" + i;
          chgIdName = document.getElementById("vaccine_err_" + chgId);
          chgIdName.id = "vaccine_err_" + i;
          //接種回数
          chgIdName = document.getElementById("vacTbIno_" + chgId);
          chgIdName.id = "vacTbIno_" + i;
          chgIdName.name = "vacTbIno_" + i;
          chgIdName = document.getElementById("help-exp-vaccine_" + chgId);
          chgIdName.id = "help-exp-vaccine_" + i;
          //あとはラベルの書き換え
        }
      }
      self.AppendSymptom();
      // 4/16修正
      self.clearOtherSymptom();
      for (var i=1;i<11;i++) {
        var element = document.getElementById('Others'+i+'-error');
        if ( element != null ) {
          var check = self.errorClearElement(element);
        }
      }
      var errEle = document.getElementById('Symptom_Vaccine_err');
      errEle.innerHTML = "";
    });
  };

  blueShipLab.prototype.removeCloneTime = function() {
    var self = this;
    self.document.on('click', '.insert-time', function(e) {
      e.preventDefault();
      var $this = $(this);

      var first = self.firstTable;
      var clone = first.find('.wrap-date-vaccinations').children().clone();

      var VaccineTabJapaneseCalendar = first.find('[name="VaccineTab_FollowJapaneseCalendar_1"]').val();

      var VaccineTabYear = first.find('[name="vacTbYY_1"]').val();
      var VaccineTabMonth = first.find('[name="vacTbMth_1"]').val();
      var VaccineTabDay = first.find('[name="vacTbDD_1"]').val();
      var VaccineTabHour = first.find('[name="vacTbHH_1"]').val();
      var VaccineTabMinute = first.find('[name="vacTbMin_1"]').val();

      var parent = $(this).closest('.clone');
      var vacChangeCnt = parent[0].childNodes[1].childNodes[1].innerHTML;
      var insertData = parent.find('.wrap-date-vaccinations');

//      insertData.children().remove();
//      insertData.append(clone);

      parent.find('select[data-set-time="VaccineTab_FollowJapaneseCalendar"]').val(VaccineTabJapaneseCalendar);
      parent.find('select[data-set-time="vacTbYY"]').val(VaccineTabYear);
      parent.find('select[data-set-time="vacTbMth"]').val(VaccineTabMonth);
      setDayAction( $('#month-vaccine_' + vacChangeCnt)  , $('#days-vaccine_' + vacChangeCnt ) , true );
      parent.find('select[data-set-time="vacTbDD"]').val(VaccineTabDay);
      parent.find('select[data-set-time="vacTbHH"]').val(VaccineTabHour);
      parent.find('select[data-set-time="vacTbMin"]').val(VaccineTabMinute);
    });
  };

  blueShipLab.prototype.AppendSymptom = function() {
    var hasSymptom = $('.has-symptom');
    var hasOtherSymtom = $('.has-otherSymptom');
    var vacCnt=1;
    var allSymptom = [],
      allSymptomValues = [];

    $('.choose-vaccine').each(function() {
      var $this = $(this);
      var VaccineValue = $this.val();
      var vacType = document.getElementById("spontaneous_"+vacCnt).checked;
      if (VaccineValue != "" && VaccineValue != null) {
        var parentID = $this.closest('.clone').attr('id');
        if (vacType && VaccineValue != "Blank") {
          VaccineValue = "任意接種";
        }
          var symptom = symptomdata[VaccineValue].symptom;
        var symptomObj = {
          parentID: parentID,
          symptom: []
        };
      
        for (var k in symptom) {
          var tempVal = symptom[k].value;
          if (allSymptomValues.indexOf(tempVal) == -1) {
            allSymptomValues.push(tempVal);

            symptomObj.symptom.push(symptom[k]);

          }
        }
        allSymptom.push(symptomObj);
        vacCnt = vacCnt + 1;
      }
    });

    var insert = '';

    for (var i in allSymptom) {
      var objs = allSymptom[i];
      for (var j in objs.symptom) {
        var obj = objs.symptom[j];
        var inputID = objs.parentID + i + j;
        insert += '<label class="for-checkbox" for="Symptom_' + inputID + '">';
        if (obj.value == "急性散在性脳脊髄炎（ADEM)") {
          insert += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="lr_' + obj.value + '" onclick=showAdemGbs(this,"ademInputForm") required aria-required="true">';
        }else if(obj.value == "ギラン・バレ症候群"){
          insert += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="lr_' + obj.value + '" onclick=showAdemGbs(this,"gbsInputForm") required aria-required="true">';
        // ▼▼▼
        }else if(obj.value == "血栓症（血栓塞栓症を含む。）（血小板減少症を伴うものに限る。）"){
          insert += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="lr_' + obj.value + '" onclick=showTts(this,"ttsInputForm") required aria-required="true">';
       // ▲▲▲
        }else if(obj.value == "心筋炎"){
          insert += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="lr_' + obj.value + '" onclick=showMyo(this,"myoInputForm") required aria-required="true">';

        }else if(obj.value == "心膜炎"){
          insert += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="lr_' + obj.value + '" onclick=showPer(this,"perInputForm") required aria-required="true">';

        }else {
          insert += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="lr_' + obj.value + '" required aria-required="true">';
        }
        insert += obj.label;
        insert += '</label>';
      }
    }
    
    hasSymptom.children().remove().end().append(insert); 
    var VaccineCnt = 0;
    vacCnt=1;
    $('.choose-vaccine').each(function() {
      var $this = $(this);
      var VaccineValue = $this.val();
      var vacType = document.getElementById("spontaneous_"+vacCnt).checked;
      if (VaccineValue != "" && VaccineValue != null) {
        var parentID = $this.closest('.clone').attr('id');
        if (vacType && VaccineValue != "Blank") {
          VaccineValue = "任意接種";
        }
        var Othersymptom = symptomdata[VaccineValue].othersymptom;

        var symptomObj = {
          parentID: parentID,
          Othersymptom: []
        };

        for (var k in Othersymptom) {
          var tempVal = Othersymptom[k].value;
          if (allSymptomValues.indexOf(tempVal) == -1) {
            allSymptomValues.push(tempVal);

            symptomObj.Othersymptom.push(Othersymptom[k]);
          }
        }
//        if (VaccineCnt == 0) {
//          var obj = {value:"不明",label:"不明" };
//          symptomObj.Othersymptom.push(obj);
//        }
        allSymptom.push(symptomObj);
        VaccineCnt++;
        vacCnt=vacCnt + 1;
      }
    });

    var insertOthersymptom = '';

    for (var i in allSymptom) {
      var objs = allSymptom[i];
      for (var j in objs.Othersymptom) {
        var obj = objs.Othersymptom[j];
        var inputID = objs.parentID + i + j;
        insertOthersymptom += '<label class="for-checkbox" for="Symptom_' + inputID + '">';
        if (obj.value == "急性散在性脳脊髄炎（ADEM)") {
          insertOthersymptom += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="' + obj.value + '" onclick=showAdemGbs(this,"ademInputForm") required aria-required="true">';
        }else if(obj.value == "ギラン・バレ症候群"){
          insertOthersymptom += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="' + obj.value + '" onclick=showAdemGbs(this,"gbsInputForm") required aria-required="true">';
        // ▼▼▼
        }else if(obj.value == "血栓症（血栓塞栓症を含む。）（血小板減少症を伴うものに限る。）"){
          insertOthersymptom += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="' + obj.value + '" onclick=showTts(this,"ttsInputForm") required aria-required="true">';
        // ▲▲▲
        }else if(obj.value == "心筋炎"){
          insertOthersymptom += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="lr_' + obj.value + '" onclick=showMyo(this,"myoInputForm") required aria-required="true">';

        }else if(obj.value == "心膜炎"){
          insertOthersymptom += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="lr_' + obj.value + '" onclick=showPer(this,"perInputForm") required aria-required="true">';

        }else{
          insertOthersymptom += '<input type="checkbox" name="Symptom_Vaccine" class="check_symptom" id="Symptom_' + inputID + '" value="' + obj.value + '" required aria-required="true">';
        }
        insertOthersymptom += obj.label;
        insertOthersymptom += '</label>';
      }
    }
    hasOtherSymtom.children().remove().end().append(insertOthersymptom);
    this.checkSymptomNum =$('.check_symptom');
    this.symptomCheck();
  };

  blueShipLab.prototype.bindAppendSymptom = function() {
    var self = this;
    self.document.on('change', '.choose-vaccine', function(e) {
      e.preventDefault();
      self.AppendSymptom();
      self.getOccursDateFromLast();
      // 4/16修正 No8
      //上記以外の症状のクリアを行う
      self.clearOtherSymptom();
    });
  };

  blueShipLab.prototype.bindAppendSymptomByChangeType = function() {
    var self = this;
    self.document.on('change', '.choose-type', function(e) {
      e.preventDefault();
      // 4/16修正 No8
      self.AppendSymptom();
      self.getOccursDateFromLast();
      // 4/16修正 No8
      //上記以外の症状のクリアを行う
      self.clearOtherSymptom();
    });
  };
  
  blueShipLab.prototype.clearOtherSymptom = function() {
    var symptoms = document.getElementsByName('Symptom_Vaccine');
    var len = symptoms.length;
    for (var i=0;i<len;i++) {
      symptoms[i].checked = false;
    }
    document.getElementById('Others1').disabled = true;
    document.getElementById('Others1').value = "";
    document.getElementById('Others2').disabled = true;
    document.getElementById('Others2').value = "";
    document.getElementById('Others3').disabled = true;
    document.getElementById('Others3').value = "";
    document.getElementById('Others4').disabled = true;
    document.getElementById('Others4').value = "";
    document.getElementById('Others5').disabled = true;
    document.getElementById('Others5').value = "";
    document.getElementById('Others6').disabled = true;
    document.getElementById('Others6').value = "";
    document.getElementById('Others7').disabled = true;
    document.getElementById('Others7').value = "";
    document.getElementById('Others8').disabled = true;
    document.getElementById('Others8').value = "";
    document.getElementById('Others9').disabled = true;
    document.getElementById('Others9').value = "";
    document.getElementById('Others10').disabled = true;
    document.getElementById('Others10').value = "";
  };
  
  blueShipLab.prototype.bindJapaneseYear = function() {
    var self = this;
    self.document.on('change', '.Japanese-year', function(e) {
      e.preventDefault();
      var $this = $(this);
      var yearvalue = $this.val();
      var thisClosest = $this.closest('.wrap-time');
      var setYear = thisClosest.find('.Year-follow-JapaneseCalendar');

      var years = yeardata[yearvalue];
      if (undefined == years.end) {
        var currentDate = new Date()
        years.end = currentDate.getFullYear();
      }
      years = years.end - years.start + 1;

      var i = 1;
      var options = '';
      while (i <= years) {
        options += '<option value="' + i + '">' + i + '</option>';
        i++;
      }

      setYear.children().not(":first").remove();
      setYear.append(options);

      if (thisClosest.hasClass('wrap-time-birthday')) {
        setYear.append('<option value="unknow">不明</option>');
      }

      return false;
    });
  };

  blueShipLab.prototype.bindChangeDecimal = function() {
    var self = this;
    self.document.on('change', '.get_body_temperature', function() {
      var $this = $(this);
      var getValue = $(this).val();
      var newValue = parseFloat(getValue).toFixed(1);
      if (isNaN(newValue)){
        newValue = "";
      }
      $this.val(newValue);
    });
  };

  blueShipLab.prototype.bindFuriganaShim = function() {
    $(".name1").furigana(".name11");
    $(".name2").furigana(".name22");
  };

  blueShipLab.prototype.bindToggleNav = function() {
    var self = this;
    var dropdown = $('.dropdown');
    var dropdownMenu = $('.dropdown-menu');

    self.document.on('click', '.toggle-dropdown-menu', function(e) {
      e.preventDefault();
      var $this = $(this);

      var next = $this.next();
      if (next.is(':visible')) {
        dropdownMenu.hide();
        next.hide();
      } else {
        dropdownMenu.hide();
        next.toggle();
      }

    });

    self.document.on('click', function(e) {
      if (!$(e.target).closest(dropdown).length) {
        dropdownMenu.hide();
      }
    });
  };

  blueShipLab.prototype.bindChangeFont = function() {
    var self = this;
    self.btnChangeFont.on('click', function(e) {
      e.preventDefault();
      var $this = $(this);
      if ($this.hasClass('custom-font-big')) {
        self.html.removeClass('custom-font-small');
        self.html.addClass('custom-font-big');
      } else if ($this.hasClass('custom-font-small')) {
        self.html.removeClass('custom-font-big');
        self.html.addClass('custom-font-small');
      } else {
        self.html.removeClass('custom-font-small custom-font-big');
      }
    });
  };

  blueShipLab.prototype.toggleHelp = function() {
    var self = this;
    self.btnToggleHelpOn.on('click', function(e) {
      e.preventDefault();
      self.html.addClass('helping');
    });

    self.btnToggleHelpOff.on('click', function(e) {
      e.preventDefault();
      self.html.removeClass('helping');
    });
  };

  var appObj = new blueShipLab();
  appObj.init();

});

$(window).resize(function() {
  $('body').css('padding-top', $('#main-header').height() + 80 );
});