package jp.co.systembase.core;

import java.math.BigDecimal;

public class Cast {

	public static boolean toBool(Object v){
		if (v instanceof Boolean){
			return (Boolean)v;
		}else{
			return false;
		}
	}

	public static float toFloat(Object v){
		if (v instanceof Float){
			return (Float)v;
		}else{
			BigDecimal _v = toBigDecimal(v);
			if (_v != null){
				return _v.floatValue();
			}else{
				return 0f;
			}
		}
	}

	public static int toInt(Object v){
		if (v instanceof Integer){
			return (Integer)v;
		}else{
			BigDecimal _v = toBigDecimal(v);
			if (_v != null){
				return _v.intValue();
			}else{
				return 0;
			}
		}
	}

	public static BigDecimal toBigDecimal(Object v){
		if (v instanceof BigDecimal){
			return (BigDecimal)v;
		}else if (v instanceof Byte){
			return new BigDecimal((Byte)v);
		}else if (v instanceof Short){
			return new BigDecimal((Short)v);
		}else if (v instanceof Integer){
			return new BigDecimal((Integer)v);
		}else if (v instanceof Long){
			return new BigDecimal((Long)v);
		}else if (v instanceof Float){
			return new BigDecimal((Float)v);
		}else if (v instanceof Double){
			return new BigDecimal((Double)v);
		}
		return null;
	}

}
