package jp.co.systembase.core;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DataTable extends ArrayList<DataRecord> {
	private static final long serialVersionUID = -9150852550012016518L;

	public List<String> fieldNames = null;

	public DataTable(){}

	public DataTable(ResultSet rs) throws SQLException{
		while(rs.next()){
			DataRecord r = new DataRecord();
			ResultSetMetaData md = rs.getMetaData();
			for(int j = 1;j <= md.getColumnCount();j++){
				r.put(md.getColumnName(j), rs.getObject(j));
			}
			this.add(r);
		}
	}

	public void setFieldNames(String...f){
		this.fieldNames = new ArrayList<String>();
		for(String _f: f){
			this.fieldNames.add(_f);
		}
	}

	public DataRecord addRecord(){
		DataRecord r = new DataRecord();
		r.fieldNames = this.fieldNames;
		this.add(r);
		return r;
	}

}
