package jp.co.systembase.core;

import java.math.BigDecimal;

public class Round {

	private static final BigDecimal[] DIGIT_UNIT = {
		new BigDecimal("0.0000000001"),
		new BigDecimal("0.000000001"),
		new BigDecimal("0.00000001"),
		new BigDecimal("0.0000001"),
		new BigDecimal("0.000001"),
		new BigDecimal("0.00001"),
		new BigDecimal("0.0001"),
		new BigDecimal("0.001"),
		new BigDecimal("0.01"),
		new BigDecimal("0.1"),
		new BigDecimal("1"),
		new BigDecimal("10"),
		new BigDecimal("100"),
		new BigDecimal("1000"),
		new BigDecimal("10000"),
		new BigDecimal("100000"),
		new BigDecimal("1000000"),
		new BigDecimal("10000000"),
		new BigDecimal("100000000"),
		new BigDecimal("1000000000"),
		new BigDecimal("10000000000"),
		new BigDecimal("100000000000"),
		new BigDecimal("1000000000000"),
		new BigDecimal("10000000000000"),
		new BigDecimal("100000000000000"),
		new BigDecimal("1000000000000000"),
	};

	public static BigDecimal roundUp(BigDecimal v, int digit){
		BigDecimal d = (new BigDecimal(1)).multiply(DIGIT_UNIT[-digit + 10]);
		BigDecimal tmp = v.abs().multiply(d).add(new BigDecimal("0.9")).setScale(0, BigDecimal.ROUND_DOWN);
		return tmp.divide(d).multiply(new BigDecimal(v.signum()));
	}

	public static BigDecimal roundUp2(BigDecimal v, int digit){
		BigDecimal d = (new BigDecimal(1)).multiply(DIGIT_UNIT[-digit + 10]);
		BigDecimal _v = v.abs().multiply(d);
		BigDecimal tmp = _v.setScale(0, BigDecimal.ROUND_DOWN);
		if (_v.compareTo(tmp) > 0){
			tmp = tmp.add(BigDecimal.ONE);
		}
		return tmp.divide(d).multiply(new BigDecimal(v.signum()));
	}

	public static BigDecimal roundDown(BigDecimal v, int digit){
		BigDecimal d = (new BigDecimal(1)).multiply(DIGIT_UNIT[-digit + 10]);
		BigDecimal tmp = v.abs().multiply(d).setScale(0, BigDecimal.ROUND_DOWN);
		return tmp.divide(d).multiply(new BigDecimal(v.signum()));
	}

	public static BigDecimal round5(BigDecimal v, int digit){
		BigDecimal d = (new BigDecimal(1)).multiply(DIGIT_UNIT[-digit + 10]);
		BigDecimal tmp = v.abs().multiply(d).add(new BigDecimal("0.5")).setScale(0, BigDecimal.ROUND_DOWN);
		return tmp.divide(d).multiply(new BigDecimal(v.signum()));
	}

	public static BigDecimal round5E(BigDecimal v, int digit){
		BigDecimal d = (new BigDecimal(1)).multiply(DIGIT_UNIT[-digit + 10]);
		BigDecimal _v = v.abs().multiply(d).stripTrailingZeros();
		BigDecimal _tv = _v.setScale(0, BigDecimal.ROUND_DOWN);
		BigDecimal tmp;
		if (_v.subtract(_tv).equals(new BigDecimal("0.5"))){
			tmp = _tv;
			if (tmp.remainder(new BigDecimal("2")).equals(BigDecimal.ONE)){
				tmp = tmp.add(BigDecimal.ONE);
			}
		}else{
			tmp = _v.add(new BigDecimal("0.5")).setScale(0, BigDecimal.ROUND_DOWN);
		}
		return tmp.divide(d).multiply(new BigDecimal(v.signum()));
	}

	public static BigDecimal round6(BigDecimal v, int digit){
		BigDecimal d = (new BigDecimal(1)).multiply(DIGIT_UNIT[-digit + 10]);
		BigDecimal tmp = v.abs().multiply(d).add(new BigDecimal("0.4")).setScale(0, BigDecimal.ROUND_DOWN);
		return tmp.divide(d).multiply(new BigDecimal(v.signum()));
	}

	public static BigDecimal round7(BigDecimal v, int digit){
		BigDecimal d = (new BigDecimal(1)).multiply(DIGIT_UNIT[-digit + 10]);
		BigDecimal tmp = v.abs().multiply(d).add(new BigDecimal("0.3")).setScale(0, BigDecimal.ROUND_DOWN);		
		return tmp.divide(d).multiply(new BigDecimal(v.signum()));
	}

}
